/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.clustering;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import net.e6tech.elements.jmx.stat.Measurement;
import net.e6tech.elements.network.clustering.Cluster;
import net.e6tech.elements.network.clustering.Member;

public class ClusterService
implements Serializable {
    private String name;
    private Member member;
    private URL[] urls;
    private int port;
    private Measurement measurement = new Measurement();
    private int hashcode = 0;
    private transient boolean healthy = true;
    private transient Map<URL, Boolean> reachableURLs = new Hashtable<URL, Boolean>();

    public static ClusterService newInstance(String name, String address) throws MalformedURLException {
        URL url = new URL(address);
        ClusterService service = new ClusterService();
        service.setName(name);
        service.setPort(url.getPort());
        try {
            if (url.getHost().equals("0.0.0.0")) {
                InetAddress[] addresses = Cluster.getHostAddresses();
                URL[] urls = new URL[addresses.length];
                for (int i = 0; i < addresses.length; ++i) {
                    urls[i] = new URL(url.getProtocol(), addresses[i].getHostAddress(), url.getPort(), url.getFile());
                }
                service.setUrls(urls);
            } else {
                service.setUrls(new URL[]{url});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return service;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("name=" + this.name + " ");
        builder.append("member=" + this.member + " ");
        builder.append(this.measurement);
        return builder.toString();
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public void setHealthy(boolean healthy) {
        this.healthy = healthy;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.measurement.setName(name);
        this.measurement.setUnit("ms");
    }

    public Member getMember() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public URL[] getUrls() {
        return this.urls;
    }

    public void setUrls(URL[] urls) {
        this.urls = urls;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean hasReachableURLs() {
        if (this.urls == null) {
            return false;
        }
        for (URL u : this.urls) {
            Boolean reacheable = this.reachableURLs.get(u);
            if (reacheable == null) {
                return true;
            }
            if (!reacheable.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public URL getReachableURL() {
        if (this.urls == null) {
            return null;
        }
        for (URL u : this.urls) {
            Boolean reacheable = this.reachableURLs.get(u);
            if (reacheable == null) {
                return u;
            }
            if (!reacheable.booleanValue()) continue;
            return u;
        }
        return null;
    }

    public void setReachable(URL url, boolean reacheable) {
        if (this.urls == null) {
            return;
        }
        for (URL u : this.urls) {
            if (!u.equals(url)) continue;
            this.reachableURLs.put(u, reacheable);
        }
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    public void setMeasurement(Measurement measurement) {
        this.measurement = measurement;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = (this.member.getUuid() + this.name).hashCode();
        }
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClusterService)) {
            return false;
        }
        ClusterService s = (ClusterService)obj;
        if (this.name == null || s.getName() == null) {
            return false;
        }
        if (this.member == null || s.getMember() == null) {
            return false;
        }
        if (this.member.getUuid() == null) {
            return false;
        }
        return this.name.equals(s.getName()) && this.member.getUuid().equals(s.getMember().getUuid());
    }
}

