/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.shell.ssh;

import java.security.PublicKey;
import java.util.Arrays;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.network.shell.ssh.SshKeyDirectory;
import org.crsh.auth.AuthenticationPlugin;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PropertyDescriptor;

public class SshKeyAuthenticationPlugin
extends CRaSHPlugin<SshKeyAuthenticationPlugin>
implements AuthenticationPlugin<PublicKey> {
    private static Logger logger = Logger.getLogger();
    public static final PropertyDescriptor<String> AUTHORIZED_KEY_PATH = PropertyDescriptor.create((String)"auth.sshkey.path", (String)null, (String)"The path to the authorized key file");
    private SshKeyDirectory directory = new SshKeyDirectory();

    protected Iterable<PropertyDescriptor<?>> createConfigurationCapabilities() {
        return Arrays.asList(AUTHORIZED_KEY_PATH);
    }

    public String getName() {
        return "sshkey";
    }

    public SshKeyAuthenticationPlugin getImplementation() {
        return this;
    }

    public Class<PublicKey> getCredentialType() {
        return PublicKey.class;
    }

    public void init() {
        String authorizedKeyPath = (String)this.getContext().getProperty(AUTHORIZED_KEY_PATH);
        if (authorizedKeyPath != null) {
            this.directory.setDirectory(authorizedKeyPath);
            try {
                this.directory.init();
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    public boolean authenticate(String username, PublicKey credential) throws Exception {
        if (this.directory.contains(credential)) {
            logger.debug("Authenticated " + username + " with public key " + credential);
            return true;
        }
        logger.debug(username + " with public key " + credential);
        return false;
    }
}

