/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.shell.telnet;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.network.shell.telnet.ElementsPortListener;
import net.e6tech.elements.network.shell.telnet.ElementsTelnetHandler;
import net.wimpi.telnetd.io.terminal.TerminalManager;
import net.wimpi.telnetd.net.Connection;
import net.wimpi.telnetd.net.ConnectionManager;
import net.wimpi.telnetd.shell.ShellManager;
import net.wimpi.telnetd.util.StringUtil;
import org.crsh.plugin.PluginContext;
import org.crsh.telnet.term.TelnetLifeCycle;
import org.crsh.telnet.term.TermLifeCycle;
import org.crsh.vfs.Resource;

public class ElementsTelnetLifeCycle
extends TermLifeCycle {
    private final Logger log = Logger.getLogger((String)TelnetLifeCycle.class.getName());
    private Integer port;
    private String bindAddress;
    private List<ElementsPortListener> listeners;
    private static final ConcurrentHashMap<ConnectionManager, ElementsTelnetLifeCycle> map = new ConcurrentHashMap();
    private Resource config;

    static ElementsTelnetLifeCycle getLifeCycle(Connection conn) {
        return map.get(conn.getConnectionData().getManager());
    }

    public ElementsTelnetLifeCycle(PluginContext context) {
        super(context);
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public Resource getConfig() {
        return this.config;
    }

    public void setConfig(Resource config) {
        this.config = config;
    }

    protected synchronized void doInit() throws Exception {
        Properties props = new Properties();
        props.load(new ByteArrayInputStream(this.config.getContent()));
        if (this.port != null) {
            this.log.debug("Explicit telnet port configuration with value " + this.port);
            props.put("std.port", this.port.toString());
        } else {
            this.log.debug("Use default telnet port configuration " + props.getProperty("std.port"));
        }
        if (this.bindAddress != null) {
            props.put("std.bind_address", this.bindAddress);
        }
        props.put("shell.simple.class", ElementsTelnetHandler.class.getName());
        ShellManager.createShellManager((Properties)props);
        TerminalManager.createTerminalManager((Properties)props);
        ArrayList<ElementsPortListener> listeners = new ArrayList<ElementsPortListener>();
        String[] listnames = StringUtil.split((String)props.getProperty("listeners"), (String)",");
        for (String listname : listnames) {
            ElementsPortListener listener = ElementsPortListener.createPortListener(listname, props);
            listeners.add(listener);
        }
        this.listeners = listeners;
        for (ElementsPortListener listener : this.listeners) {
            listener.start();
            map.put(listener.getConnectionManager(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doDestroy() {
        this.log.info("Destroying telnet life cycle");
        if (this.listeners != null) {
            List<ElementsPortListener> listeners = this.listeners;
            this.listeners = null;
            for (ElementsPortListener listener : listeners) {
                try {
                    listener.stop();
                }
                catch (Exception exception) {}
                continue;
                finally {
                    map.remove(listener.getConnectionManager());
                }
            }
        }
    }
}

