/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.shell.ssh;

import java.nio.charset.Charset;
import java.security.PublicKey;
import java.util.ArrayList;
import net.e6tech.elements.common.logging.Logger;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.cipher.AES128CBC;
import org.apache.sshd.common.cipher.AES192CBC;
import org.apache.sshd.common.cipher.AES256CBC;
import org.apache.sshd.common.cipher.BlowfishCBC;
import org.apache.sshd.common.cipher.TripleDESCBC;
import org.apache.sshd.common.mac.HMACMD5;
import org.apache.sshd.common.mac.HMACMD596;
import org.apache.sshd.common.mac.HMACSHA196;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.crsh.auth.AuthenticationPlugin;
import org.crsh.plugin.PluginContext;
import org.crsh.shell.ShellFactory;
import org.crsh.ssh.term.CRaSHCommandFactory;
import org.crsh.ssh.term.SSHLifeCycle;
import org.crsh.ssh.term.scp.SCPCommandFactory;
import org.crsh.ssh.term.subsystem.SubsystemFactoryPlugin;

public class ElementsSSHLifeCycle {
    private static Logger log = Logger.getLogger();
    private final PluginContext context;
    private final int port;
    private final int idleTimeout;
    private final int authTimeout;
    private final Charset encoding;
    private final KeyPairProvider keyPairProvider;
    private final ArrayList<AuthenticationPlugin> authenticationPlugins;
    private SshServer server;
    private Integer localPort;

    public ElementsSSHLifeCycle(PluginContext context, Charset encoding, int port, int idleTimeout, int authTimeout, KeyPairProvider keyPairProvider, ArrayList<AuthenticationPlugin> authenticationPlugins) {
        this.authenticationPlugins = authenticationPlugins;
        this.context = context;
        this.encoding = encoding;
        this.port = port;
        this.idleTimeout = idleTimeout;
        this.authTimeout = authTimeout;
        this.keyPairProvider = keyPairProvider;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public int getPort() {
        return this.port;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public int getAuthTimeout() {
        return this.authTimeout;
    }

    public Integer getLocalPort() {
        return this.localPort;
    }

    public KeyPairProvider getKeyPairProvider() {
        return this.keyPairProvider;
    }

    public void init() {
        try {
            ShellFactory factory = (ShellFactory)this.context.getPlugin(ShellFactory.class);
            SshServer server = SshServer.setUpDefaultServer();
            ArrayList macs = new ArrayList();
            server.getMacFactories().forEach(mac -> {
                if (!(mac.getName().equals(new HMACMD596.Factory().getName()) || mac.getName().equals(new HMACSHA196.Factory().getName()) || mac.getName().equals(new HMACMD5.Factory().getName()))) {
                    macs.add(mac);
                }
            });
            server.setMacFactories(macs);
            ArrayList ciphers = new ArrayList();
            server.getCipherFactories().forEach(cipher -> {
                if (!(cipher.getName().equals(new AES128CBC.Factory().getName()) || cipher.getName().equals(new AES192CBC.Factory().getName()) || cipher.getName().equals(new AES256CBC.Factory().getName()) || cipher.getName().equals(new TripleDESCBC.Factory().getName()) || cipher.getName().equals(new BlowfishCBC.Factory().getName()))) {
                    ciphers.add(cipher);
                }
            });
            server.setCipherFactories(ciphers);
            server.setPort(this.port);
            if (this.idleTimeout > 0) {
                server.getProperties().put("idle-timeout", String.valueOf(this.idleTimeout));
            }
            if (this.authTimeout > 0) {
                server.getProperties().put("auth-timeout", String.valueOf(this.authTimeout));
            }
            server.setShellFactory((Factory)new CRaSHCommandFactory(factory, this.encoding));
            server.setCommandFactory((CommandFactory)new SCPCommandFactory(this.context));
            server.setKeyPairProvider(this.keyPairProvider);
            ArrayList<NamedFactory> namedFactoryList = new ArrayList<NamedFactory>(0);
            for (SubsystemFactoryPlugin plugin : this.context.getPlugins(SubsystemFactoryPlugin.class)) {
                namedFactoryList.add(plugin.getFactory());
            }
            server.setSubsystemFactories(namedFactoryList);
            for (AuthenticationPlugin authenticationPlugin : this.authenticationPlugins) {
                if (server.getPasswordAuthenticator() == null && authenticationPlugin.getCredentialType().equals(String.class)) {
                    server.setPasswordAuthenticator(new PasswordAuthenticator(){

                        public boolean authenticate(String _username, String _password, ServerSession session) {
                            if (ElementsSSHLifeCycle.this.genericAuthenticate(String.class, _username, _password)) {
                                session.setAttribute(SSHLifeCycle.USERNAME, (Object)_username);
                                session.setAttribute(SSHLifeCycle.PASSWORD, (Object)_password);
                                return true;
                            }
                            return false;
                        }
                    });
                }
                if (server.getPublickeyAuthenticator() != null || !authenticationPlugin.getCredentialType().equals(PublicKey.class)) continue;
                server.setPublickeyAuthenticator(new PublickeyAuthenticator(){

                    public boolean authenticate(String username, PublicKey key, ServerSession session) {
                        if (ElementsSSHLifeCycle.this.genericAuthenticate(PublicKey.class, username, key)) {
                            session.setAttribute(SSHLifeCycle.USERNAME, (Object)username);
                            return true;
                        }
                        return false;
                    }
                });
            }
            log.info("About to start CRaSSHD");
            server.start();
            this.localPort = server.getPort();
            log.info("CRaSSHD started on port " + this.localPort);
            this.server = server;
        }
        catch (Throwable e) {
            log.error("Could not start CRaSSHD", e);
        }
    }

    public void destroy() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (InterruptedException e) {
                log.debug("Got an interruption when stopping server", (Throwable)e);
            }
        }
    }

    private <T> boolean genericAuthenticate(Class<T> type, String username, T credential) {
        for (AuthenticationPlugin authenticationPlugin : this.authenticationPlugins) {
            if (!authenticationPlugin.getCredentialType().equals(type)) continue;
            try {
                log.info("Using authentication plugin " + authenticationPlugin + " to authenticate user " + username);
                AuthenticationPlugin authPlugin = authenticationPlugin;
                if (!authPlugin.authenticate(username, credential)) continue;
                return true;
            }
            catch (Exception e) {
                log.error("Exception authenticating user " + username + " in authentication plugin: " + authenticationPlugin, (Throwable)e);
            }
        }
        return false;
    }
}

