/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import net.e6tech.elements.common.logging.Logger;

public class Transfer
implements Runnable {
    private static Logger logger = Logger.getLogger();
    String host;
    int port;
    Socket client;
    ExecutorService threadPool;

    public Transfer(String host, int port, Socket client, ExecutorService threadPool) {
        this.host = host;
        this.port = port;
        this.client = client;
        this.threadPool = threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] request = new byte[4096];
        byte[] response = new byte[4096];
        Socket remote = null;
        try {
            InputStream clientInputStream = this.client.getInputStream();
            OutputStream clientOutputStream = this.client.getOutputStream();
            try {
                remote = new Socket(this.host, this.port);
            }
            catch (IOException e) {
                logger.warn("Cannot connect to " + this.host + " on port " + this.port, (Throwable)e);
                this.client.close();
                try {
                    if (remote != null) {
                        remote.close();
                    }
                    if (this.client != null) {
                        this.client.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            InputStream remoteInputStream = remote.getInputStream();
            OutputStream remoteOutputStream = remote.getOutputStream();
            this.threadPool.execute(() -> {
                try {
                    int read;
                    while ((read = clientInputStream.read(request)) != -1) {
                        remoteOutputStream.write(request, 0, read);
                        remoteOutputStream.flush();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    remoteOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            try {
                int read;
                while ((read = remoteInputStream.read(response)) != -1) {
                    clientOutputStream.write(response, 0, read);
                    clientOutputStream.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            clientOutputStream.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        finally {
            try {
                if (remote != null) {
                    remote.close();
                }
                if (this.client != null) {
                    this.client.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

