/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.shell;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.security.Password;
import org.crsh.auth.AuthenticationPlugin;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PropertyDescriptor;

public class PasswordAuthenticationPlugin
extends CRaSHPlugin<AuthenticationPlugin>
implements AuthenticationPlugin<String> {
    public static final PropertyDescriptor<String> AUTHORIZED_PASSWORD_FILE = PropertyDescriptor.create((String)"auth.password.file", (String)null, (String)"The path to the authorized key file");
    private static Logger logger = Logger.getLogger();
    private Map<String, String> passwords = new LinkedHashMap<String, String>();
    private WatchService watcher;
    private Path path;

    protected Iterable<PropertyDescriptor<?>> createConfigurationCapabilities() {
        return Arrays.asList(AUTHORIZED_PASSWORD_FILE);
    }

    public Class<String> getCredentialType() {
        return String.class;
    }

    public AuthenticationPlugin getImplementation() {
        return this;
    }

    public void init() {
        String passwordFile = (String)this.getContext().getProperty(AUTHORIZED_PASSWORD_FILE);
        this.path = Paths.get(passwordFile, new String[0]);
        this.loadFile(this.path);
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            Paths.get(passwordFile, new String[0]).register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage());
        }
    }

    public String getName() {
        return "password";
    }

    public boolean hasPassword(String username) {
        this.poll();
        String onFile = this.passwords.get(username);
        return onFile != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePassword(String username, String password) throws Exception {
        if (username == null) {
            throw new IllegalArgumentException("user name cannot be null");
        }
        String pwd = Password.getSaltedHash((char[])password.toCharArray());
        this.passwords.put(username, pwd);
        BufferedWriter writer = null;
        try {
            writer = Files.newBufferedWriter(this.path, Charset.forName("UTF-8"), new OpenOption[0]);
            for (Map.Entry<String, String> entry : this.passwords.entrySet()) {
                writer.write(entry.getKey());
                writer.write(" ");
                writer.write(entry.getValue());
                writer.newLine();
                writer.flush();
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean authenticate(String username, String password) throws Exception {
        this.poll();
        if (this.passwords.size() == 0) {
            return true;
        }
        String onFile = this.passwords.get(username);
        if (onFile == null) {
            return false;
        }
        return Password.check((char[])password.toCharArray(), (String)onFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(Path path) {
        BufferedReader reader = null;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            String line;
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            reader = Files.newBufferedReader(path);
            while ((line = reader.readLine()) != null && line.trim().length() > 0) {
                try {
                    String[] components = line.split(" ");
                    map.put(components[0].trim(), components[1].trim());
                }
                catch (Exception ex) {
                    logger.warn("Cannot add public key in file " + path + ": " + ex.getMessage());
                }
            }
            this.passwords = map;
        }
        catch (Exception ex) {
            logger.warn("Cannot add public key in file " + path + ": " + ex.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() {
        WatchKey key = this.watcher.poll();
        while (key != null) {
            try {
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                        this.passwords.clear();
                        continue;
                    }
                    WatchEvent<?> ev = event;
                    Path filename = (Path)ev.context();
                    Path file = this.path.resolve(filename);
                    if (!Files.exists(file, new LinkOption[0])) continue;
                    try {
                        this.loadFile(file);
                    }
                    catch (Exception e) {
                        logger.warn("Error reading " + file, (Throwable)e);
                    }
                }
            }
            finally {
                key.reset();
                key = this.watcher.poll();
            }
        }
    }
}

