/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.proxy;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Startable;
import net.e6tech.elements.network.proxy.Transfer;

public class SocketProxyServer
implements Startable,
Runnable {
    private static Logger logger = Logger.getLogger();
    private String remoteHost;
    private int remotePort;
    private int localPort;
    private ServerSocket serverSocket;
    private ExecutorService threadPool;

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public void start() {
        if (this.threadPool == null) {
            ThreadGroup group = Thread.currentThread().getThreadGroup();
            this.threadPool = Executors.newCachedThreadPool(runnable -> {
                Thread thread = new Thread(group, runnable, "SocketProxyServer");
                thread.setName("SocketProxyServer-" + thread.getId());
                thread.setDaemon(true);
                return thread;
            });
        }
        this.threadPool.execute(this);
    }

    @Override
    public void run() {
        try {
            this.serverSocket = new ServerSocket(this.localPort);
            while (true) {
                try {
                    while (true) {
                        Transfer transfer = new Transfer(this.remoteHost, this.remotePort, this.serverSocket.accept(), this.threadPool);
                        this.threadPool.execute(transfer);
                    }
                }
                catch (IOException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable th) {
            throw logger.runtimeException(th);
        }
    }
}

