/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.shell;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.ServiceLoaderDiscovery;

public class PluginDiscovery
extends ServiceLoaderDiscovery {
    protected List<CRaSHPlugin> plugins = new ArrayList<CRaSHPlugin>();
    protected boolean loaded = false;
    protected ClassLoader classLoader;

    public PluginDiscovery(ClassLoader classLoader) throws NullPointerException {
        super(classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader);
        this.classLoader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
    }

    public CRaSHPlugin addPlugin(String plugin) {
        try {
            CRaSHPlugin p = (CRaSHPlugin)Class.forName(plugin, false, this.classLoader).newInstance();
            return this.addPlugin(p);
        }
        catch (Throwable x) {
            throw new RuntimeException(x);
        }
    }

    public CRaSHPlugin addPlugin(CRaSHPlugin plugin) {
        this.getPlugins();
        this.plugins.add(plugin);
        return plugin;
    }

    public void removePlugin(String clsName) throws ClassNotFoundException {
        this.removePlugin(Class.forName(clsName, false, this.classLoader));
    }

    public void removePlugin(Class<CRaSHPlugin> cls) {
        Iterator<CRaSHPlugin<?>> iterator = this.getPlugins().iterator();
        while (iterator.hasNext()) {
            CRaSHPlugin<?> plugin = iterator.next();
            if (!plugin.getClass().equals(cls)) continue;
            iterator.remove();
        }
    }

    public Iterable<CRaSHPlugin<?>> getPlugins() {
        if (this.loaded) {
            return this.plugins;
        }
        for (CRaSHPlugin cRaSHPlugin : super.getPlugins()) {
            this.plugins.add(cRaSHPlugin);
        }
        this.loaded = true;
        return this.plugins;
    }
}

