/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.restful;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.Response;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.serialization.ObjectMapperFactory;
import net.e6tech.elements.network.clustering.ClusterClient;
import net.e6tech.elements.network.clustering.ClusterService;
import net.e6tech.elements.network.restful.Param;
import net.e6tech.elements.network.restful.Request;
import net.e6tech.elements.network.restful.Response;
import net.e6tech.elements.security.JCEKS;

public class RestfulClient {
    private static Logger logger = Logger.getLogger();
    public static ObjectMapper mapper = ObjectMapperFactory.newInstance();
    private String staticAddress;
    private String encoding = "UTF-8";
    private String trustStore;
    private boolean skipHostnameCheck = false;
    private boolean skipCertCheck = false;
    private SSLSocketFactory sslSocketFactory;
    private String clusterAddress;
    private long clusterRenewalPeriod = 300000L;
    private int connectionTimeout = -1;
    private int readTimeout = -1;
    @Inject(optional=true)
    private PrintWriter printer;
    @Inject(optional=true)
    private ClusterClient clusterClient;

    public RestfulClient() {
    }

    public RestfulClient(String address) {
        this.setAddress(address);
    }

    public synchronized String getAddress() {
        return this.staticAddress;
    }

    public synchronized void setAddress(String path) {
        this.staticAddress = path;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.sslSocketFactory = null;
        this.trustStore = trustStore;
    }

    public boolean isSkipHostnameCheck() {
        return this.skipHostnameCheck;
    }

    public void setSkipHostnameCheck(boolean skipHostnameCheck) {
        this.sslSocketFactory = null;
        this.skipHostnameCheck = skipHostnameCheck;
    }

    public boolean isSkipCertCheck() {
        return this.skipCertCheck;
    }

    public void setSkipCertCheck(boolean skipCertCheck) {
        this.sslSocketFactory = null;
        this.skipCertCheck = skipCertCheck;
    }

    public PrintWriter getPrinter() {
        return this.printer;
    }

    public void setPrinter(PrintWriter printer) {
        this.printer = printer;
    }

    public ClusterClient getClusterClient() {
        return this.clusterClient;
    }

    public void setClusterClient(ClusterClient clusterClient) {
        if (this.clusterClient != null) {
            this.clusterClient.stop();
        }
        this.clusterClient = clusterClient;
    }

    public String getClusterAddress() {
        return this.clusterAddress;
    }

    public void setClusterAddress(String clusterAddress) {
        if (this.clusterClient != null) {
            this.clusterClient.stop();
        } else {
            this.clusterClient = new ClusterClient();
        }
        this.clusterClient.setRenewalPeriod(this.clusterRenewalPeriod);
        this.clusterClient.connect(clusterAddress);
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    private Param[] toParams(Object object) {
        ArrayList<Param> params = new ArrayList<Param>();
        if (object != null) {
            Class<?> cls = object.getClass();
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(cls);
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
            for (PropertyDescriptor desc : beanInfo.getPropertyDescriptors()) {
                if (desc.getReadMethod() == null) continue;
                try {
                    Object value = desc.getReadMethod().invoke(object, new Object[0]);
                    if (value == null) continue;
                    params.add(new Param(desc.getName(), value.toString()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return params.toArray(new Param[params.size()]);
    }

    public Response get(String context, Object object) throws IOException {
        if (object instanceof Param) {
            return this.get(context, (Param)object);
        }
        return this.get(context, this.toParams(object));
    }

    public Request create() {
        return new Request(this);
    }

    public Response get(String context, Param ... params) throws IOException {
        return new Request(this).get(context, params);
    }

    public Response delete(String context, Param ... params) throws IOException {
        return new Request(this).delete(context, params);
    }

    public Response put(String context, Object data, Object object) throws IOException {
        if (object instanceof Param) {
            return this.put(context, data, (Param)object);
        }
        return this.put(context, data, this.toParams(object));
    }

    public Response put(String context, Object data, Param ... params) throws IOException {
        return new Request(this).put(context, data, params);
    }

    public Response post(String context, Object data, Object object) throws IOException {
        if (object instanceof Param) {
            return this.post(context, data, (Param)object);
        }
        return this.post(context, data, this.toParams(object));
    }

    public Response post(String context, Object data, Param ... params) throws IOException {
        return new Request(this).post(context, data, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String constructPath(String dest, String context, Param ... params) {
        String fullPath = null;
        RestfulClient restfulClient = this;
        synchronized (restfulClient) {
            if (!dest.endsWith("/")) {
                dest = dest + "/";
            }
            if (context != null) {
                while (context.startsWith("/")) {
                    context = context.substring(1);
                }
            }
            fullPath = dest + context;
        }
        while (fullPath.endsWith("/")) {
            fullPath = fullPath.substring(0, fullPath.length() - 1);
        }
        if (params != null) {
            StringBuilder builder = new StringBuilder();
            ArrayList<Param> list = new ArrayList<Param>();
            for (Param param : params) {
                if (param.getValue() == null) continue;
                list.add(param);
            }
            for (int i = 0; i < list.size(); ++i) {
                if (i == 0) {
                    builder.append("?");
                }
                builder.append(((Param)list.get(i)).encode());
                if (i == list.size() - 1) continue;
                builder.append("&");
            }
            fullPath = fullPath + builder.toString();
        }
        return fullPath;
    }

    HttpURLConnection open(String dest, String context, Param ... params) throws IOException {
        String fullPath = this.constructPath(dest, context, params);
        URL url = null;
        try {
            logger.debug(fullPath);
            url = new URL(fullPath);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            if (this.connectionTimeout >= 0) {
                conn.setConnectTimeout(this.connectionTimeout);
            }
            if (this.readTimeout >= 0) {
                conn.setReadTimeout(this.readTimeout);
            }
            if (conn instanceof HttpsURLConnection) {
                HttpsURLConnection https = (HttpsURLConnection)conn;
                https.setSSLSocketFactory(this.getSSLSocketFactory());
                if (this.skipHostnameCheck || this.skipCertCheck) {
                    https.setHostnameVerifier((hostname, session) -> true);
                }
            }
            return conn;
        }
        catch (MalformedURLException e) {
            throw logger.runtimeException((Throwable)e);
        }
    }

    protected Response submit(String context, String method, Properties requestProperties, Object data, Param ... params) throws IOException {
        while (true) {
            Destination dest = this.selectAddress();
            try {
                return this._submit(dest.address, context, method, requestProperties, data, params);
            }
            catch (IOException | NotFoundException ex) {
                if (dest.service != null) {
                    dest.service.setReachable(dest.url, false);
                    if (dest.service.hasReachableURLs()) continue;
                    dest.service.setHealthy(false);
                    continue;
                }
                throw ex;
            }
            break;
        }
    }

    protected synchronized Destination selectAddress() {
        Destination dest = new Destination();
        URL staticURL = null;
        try {
            staticURL = new URL(this.getAddress());
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        if (this.clusterClient != null) {
            do {
                dest.service = this.clusterClient.select();
                if (dest.service == null) break;
                URL[] urls = dest.service.getUrls();
                if (urls != null && urls.length > 0) {
                    URL clusterURL = dest.service.getReachableURL();
                    if (clusterURL != null) {
                        try {
                            URL newUrl = new URL(staticURL.getProtocol(), clusterURL.getHost(), clusterURL.getPort(), staticURL.getFile());
                            dest.address = newUrl.toString();
                            dest.url = clusterURL;
                            break;
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                            continue;
                        }
                    }
                    dest.service.setHealthy(false);
                    continue;
                }
                dest.service.setHealthy(false);
            } while (dest.address == null);
        }
        if (dest.service == null) {
            dest.address = this.staticAddress;
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response _submit(String dest, String context, String method, Properties requestProperties, Object data, Param ... params) throws IOException {
        Response response = null;
        HttpURLConnection conn = null;
        try {
            conn = this.open(dest, context, params);
            if (data != null) {
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/json");
            }
            conn.setRequestMethod(method);
            this.setConnectionProperties(conn);
            this.loadRequestProperties(conn, requestProperties);
            if (this.printer != null) {
                this.printer.println("REQUEST ----------------------------");
                this.printer.println(method + " " + this.constructPath(dest, context, params));
                this.printHeaders(requestProperties);
                this.printHeaders(conn.getRequestProperties());
                if (data != null) {
                    this.printer.println(mapper.writerWithDefaultPrettyPrinter().writeValueAsString(data));
                }
                this.printer.println();
            }
            if (data != null) {
                OutputStream out = conn.getOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), "UTF-8");
                String posted = mapper.writeValueAsString(data);
                writer.write(posted);
                logger.debug(posted);
                ((Writer)writer).flush();
                ((Writer)writer).close();
                out.close();
            }
            response = this.readResponse(conn);
            if (this.printer != null) {
                this.printer.println("RESPONSE ----------------------------");
                List<String> statusList = response.getHeaderFields().get(null);
                if (statusList != null && statusList.size() > 0) {
                    this.printer.println(statusList.get(0));
                }
                this.printer.println("Response Code=" + response.getResponseCode());
                this.printHeaders(response.getHeaderFields());
                String result = response.getResult();
                if (result != null && result.length() > 0) {
                    Object ret = result.startsWith("[") ? mapper.readValue(response.getResult(), List.class) : (result.startsWith("{") ? mapper.readValue(response.getResult(), Map.class) : (result.startsWith("\"") ? mapper.readValue(response.getResult(), String.class) : (Character.isDigit(result.charAt(0)) ? (result.contains(".") ? mapper.readValue(response.getResult(), BigDecimal.class) : mapper.readValue(response.getResult(), Long.class)) : (result.equalsIgnoreCase("true") || result.equalsIgnoreCase("false") ? Boolean.valueOf(Boolean.getBoolean(result)) : result))));
                    this.printer.println(mapper.writerWithDefaultPrettyPrinter().writeValueAsString(ret));
                }
                this.printer.println();
            }
            this.checkResponseCode(response);
        }
        catch (MalformedURLException e) {
            logger.runtimeException((Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return response;
    }

    private Response readResponse(HttpURLConnection conn) throws IOException {
        Response response = new Response();
        response.setHeaderFields(conn.getHeaderFields());
        response.setResponseCode(conn.getResponseCode());
        if (conn.getResponseCode() == 204) {
            return response;
        }
        InputStream in = null;
        in = conn.getResponseCode() < 200 || conn.getResponseCode() > 202 ? conn.getErrorStream() : conn.getInputStream();
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        int read = 0;
        int bufSize = 4096;
        byte[] buffer = new byte[bufSize];
        while ((read = bis.read(buffer)) != -1) {
            byteArray.write(buffer, 0, read);
        }
        String result = new String(byteArray.toByteArray(), this.encoding);
        response.setResult(result);
        return response;
    }

    private void checkResponseCode(Response response) {
        int code = response.getResponseCode();
        Response.Status status = Response.Status.fromStatusCode((int)code);
        if (code == 500) {
            throw new InternalServerErrorException();
        }
        if (code > 500) {
            throw new ServiceUnavailableException();
        }
        switch (status) {
            case OK: 
            case CREATED: 
            case ACCEPTED: 
            case NO_CONTENT: 
            case RESET_CONTENT: 
            case PARTIAL_CONTENT: {
                return;
            }
            case BAD_REQUEST: {
                throw new BadRequestException(response.getResult());
            }
            case UNAUTHORIZED: {
                throw new NotAuthorizedException(javax.ws.rs.core.Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
            case PAYMENT_REQUIRED: 
            case FORBIDDEN: {
                throw new ForbiddenException(response.getResult());
            }
            case NOT_FOUND: {
                throw new NotFoundException(response.getResult());
            }
            case METHOD_NOT_ALLOWED: {
                throw new NotAllowedException(response.getResult(), javax.ws.rs.core.Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build());
            }
            case NOT_ACCEPTABLE: {
                throw new NotAcceptableException(response.getResult());
            }
            case UNSUPPORTED_MEDIA_TYPE: {
                throw new NotSupportedException(response.getResult());
            }
        }
        throw new ServerErrorException(response.getResult(), status);
    }

    private void printHeaders(Map<String, ?> headers) {
        for (Map.Entry<String, ?> entry : headers.entrySet()) {
            String auth;
            if (entry.getKey() == null) continue;
            this.printer.print(entry.getKey() + ": ");
            if (entry.getKey().equals("Authorization") && entry.getValue() instanceof String && (auth = (String)entry.getValue()).startsWith("Bearer ")) {
                this.printer.println("Bearer ...");
                continue;
            }
            boolean first = true;
            if (entry.getValue() instanceof List) {
                for (String item : (List)entry.getValue()) {
                    if (first) {
                        first = false;
                    } else {
                        this.printer.print(", ");
                    }
                    this.printer.print(item);
                }
            } else {
                this.printer.print(entry.getValue());
            }
            this.printer.println();
        }
        this.printer.flush();
    }

    private void setConnectionProperties(HttpURLConnection conn) throws ProtocolException {
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setAllowUserInteraction(false);
        conn.setRequestProperty("Accept", "application/json");
    }

    private void loadRequestProperties(HttpURLConnection conn, Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            conn.setRequestProperty(key, properties.getProperty(key));
        }
    }

    private SSLSocketFactory getSSLSocketFactory() {
        if (this.sslSocketFactory != null) {
            return this.sslSocketFactory;
        }
        TrustManager[] trustManagers = null;
        if (this.skipCertCheck) {
            trustManagers = new TrustManager[]{new AcceptAllTrustManager()};
        } else {
            try {
                if (this.trustStore != null) {
                    JCEKS jceks = new JCEKS(this.trustStore, null);
                    trustManagers = jceks.getTrustManagers();
                } else {
                    TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    factory.init((KeyStore)null);
                    trustManagers = factory.getTrustManagers();
                }
            }
            catch (Exception ex) {
                throw logger.runtimeException((Throwable)ex);
            }
        }
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(null, trustManagers, null);
            this.sslSocketFactory = ctx.getSocketFactory();
            return this.sslSocketFactory;
        }
        catch (Exception e) {
            throw logger.runtimeException((Throwable)e);
        }
    }

    public class AcceptAllTrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    private static class Destination {
        String address;
        ClusterService service;
        URL url;

        private Destination() {
        }
    }
}

