/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.clustering;

import java.util.List;
import net.e6tech.elements.network.clustering.Balancer;
import net.e6tech.elements.network.clustering.ClusterService;

public class RoundRobinBalancer
implements Balancer {
    String uuid;

    @Override
    public ClusterService select(List<ClusterService> services) {
        if (services.size() == 0) {
            return null;
        }
        ClusterService service = null;
        if (this.uuid == null) {
            for (int i = 0; i < services.size(); ++i) {
                ClusterService s = services.get(i);
                if (!s.isHealthy()) continue;
                service = s;
            }
        } else {
            for (int i = 0; i < services.size(); ++i) {
                ClusterService s = services.get(i);
                if (!this.uuid.equals(s.getMember().getUuid())) continue;
                int idx = i + 1;
                if (idx == services.size()) {
                    idx = 0;
                }
                s = services.get(idx);
                while (!s.isHealthy()) {
                    if (++idx == services.size()) {
                        idx = 0;
                    }
                    if (idx == i) {
                        s = services.get(idx);
                        if (s.isHealthy()) break;
                        s = null;
                        break;
                    }
                    s = services.get(idx);
                }
                service = s;
                break;
            }
            if (service == null) {
                service = services.get(0);
            }
        }
        if (service != null) {
            this.uuid = service.getMember().getUuid();
        }
        if (!service.isHealthy()) {
            service = null;
        }
        return service;
    }
}

