/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.shell.telnet;

import java.io.IOException;
import java.net.URL;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.network.shell.telnet.ElementsTelnetLifeCycle;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.plugin.ResourceKind;
import org.crsh.telnet.TelnetPlugin;
import org.crsh.vfs.Resource;

public class ElementsTelnetPlugin
extends TelnetPlugin {
    private static Logger logger = Logger.getLogger();
    public static final PropertyDescriptor<String> BIND_ADDRESS = PropertyDescriptor.create((String)"telnet.bind_address", (String)"localhost", (String)"The telnet port");
    private ElementsTelnetLifeCycle lifeCycle;

    public void init() {
        Resource res;
        PluginContext context = this.getContext();
        Resource config = null;
        URL configURL = TelnetPlugin.class.getResource("/crash/telnet.properties");
        if (configURL != null) {
            try {
                logger.debug("Found embedded telnet config url " + configURL);
                config = new Resource("telnet.properties", configURL);
            }
            catch (IOException e) {
                logger.debug("Could not load embedded telnet config url " + configURL + " will bypass it", (Throwable)e);
            }
        }
        if ((res = this.getContext().loadResource("telnet.properties", ResourceKind.CONFIG)) != null) {
            config = res;
            logger.debug("Found telnet config url " + configURL);
        }
        if (configURL == null) {
            logger.info("Could not boot Telnet due to missing config");
            return;
        }
        ElementsTelnetLifeCycle lifeCycle = new ElementsTelnetLifeCycle(context);
        lifeCycle.setConfig(config);
        Integer port = (Integer)context.getProperty(TELNET_PORT);
        if (port == null) {
            port = (Integer)ElementsTelnetPlugin.TELNET_PORT.defaultValue;
        }
        lifeCycle.setPort(port);
        String bindAddress = (String)context.getProperty(BIND_ADDRESS);
        lifeCycle.setBindAddress(bindAddress);
        lifeCycle.init();
    }

    public void destroy() {
        if (this.lifeCycle != null) {
            this.lifeCycle.destroy();
        }
    }
}

