/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.shell;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.crsh.vfs.Path;
import org.crsh.vfs.spi.FSDriver;
import org.crsh.vfs.spi.FSMountFactory;
import org.crsh.vfs.spi.Mount;
import org.crsh.vfs.spi.url.Node;
import org.crsh.vfs.spi.url.URLDriver;

public class ClassPathMountFactory
implements FSMountFactory<Node> {
    private List<String> commandPaths = new ArrayList<String>();
    private final ClassLoader loader;

    public ClassPathMountFactory(ClassLoader loader) {
        this.loader = loader;
    }

    public void addCommandPath(String path) {
        this.commandPaths.add(path);
    }

    public Mount<Node> create(Path path) throws IOException {
        if (path == null) {
            throw new NullPointerException();
        }
        URLDriver driver = new URLDriver();
        if (this.commandPaths.size() > 0) {
            for (String p : this.commandPaths) {
                while (p.startsWith("/")) {
                    p = p.substring(1);
                }
                this.merge(driver, p);
            }
        } else {
            this.merge(driver, path.getValue().substring(1));
        }
        return new Mount((FSDriver)driver, "classpath:" + path.absolute().getValue());
    }

    protected void merge(URLDriver driver, String path) throws IOException {
        Enumeration<URL> en = this.loader.getResources(path);
        while (en.hasMoreElements()) {
            URL url = en.nextElement();
            try {
                driver.merge(url);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
    }
}

