/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.clustering;

import java.util.List;
import net.e6tech.elements.network.clustering.Balancer;
import net.e6tech.elements.network.clustering.ClusterService;

public class LoadBalancer
implements Balancer {
    @Override
    public ClusterService select(List<ClusterService> services) {
        ClusterService clusterService = null;
        for (ClusterService s : services) {
            if (clusterService == null) {
                if (!s.isHealthy()) continue;
                clusterService = s;
                continue;
            }
            if (!s.isHealthy()) continue;
            if (s.getMeasurement().getCount() < clusterService.getMeasurement().getCount()) {
                clusterService = s;
                continue;
            }
            if (s.getMeasurement().getCount() >= clusterService.getMeasurement().getCount() || !(s.getMeasurement().getAverage() < clusterService.getMeasurement().getAverage())) continue;
            clusterService = s;
        }
        return clusterService;
    }
}

