/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.restful;

import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.util.Properties;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.network.restful.Param;
import net.e6tech.elements.network.restful.Response;
import net.e6tech.elements.network.restful.RestfulClient;

public class Request {
    private static final String GET = "GET";
    private static final String PUT = "PUT";
    private static final String POST = "POST";
    private static final String DELETE = "DELETE";
    private static final int RETRY = 4;
    private static Logger logger = Logger.getLogger();
    private RestfulClient client;
    private String encoding = "UTF-8";
    private Properties requestProperties = new Properties();

    Request(RestfulClient client) {
        this.client = client;
    }

    public Request setRequestProperty(String key, String value) {
        this.requestProperties.setProperty(key, value);
        return this;
    }

    private void setConnectionProperties(HttpURLConnection conn) throws ProtocolException {
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setAllowUserInteraction(false);
        conn.setRequestProperty("Accept", "application/json");
    }

    private void loadRequestProperties(HttpURLConnection conn) {
        for (String key : this.requestProperties.stringPropertyNames()) {
            conn.setRequestProperty(key, this.requestProperties.getProperty(key));
        }
    }

    public Response get(String context, Param ... params) throws Throwable {
        return this.request(context, GET, null, params);
    }

    public Response delete(String context, Param ... params) throws Throwable {
        return this.request(context, DELETE, null, params);
    }

    public Response put(String context, Object data, Param ... params) throws Throwable {
        return this.request(context, PUT, data, params);
    }

    public Response post(String context, Object data, Param ... params) throws Throwable {
        return this.request(context, POST, data, params);
    }

    public Response request(String context, String method, Object data, Param ... params) throws Throwable {
        return this.client.submit(context, method, this.requestProperties, data, params);
    }
}

