/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.clustering;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.j256.simplejmx.common.JmxAttributeMethod;
import com.j256.simplejmx.common.JmxResource;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.serialization.ObjectMapperFactory;
import net.e6tech.elements.common.subscribe.Broadcast;
import net.e6tech.elements.common.subscribe.Notice;
import net.e6tech.elements.common.subscribe.Subscriber;
import net.e6tech.elements.jmx.JMXService;
import net.e6tech.elements.network.clustering.Balancer;
import net.e6tech.elements.network.clustering.ClusterService;
import net.e6tech.elements.network.clustering.ClusterServices;
import net.e6tech.elements.network.clustering.LoadBalancer;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;

@JmxResource(description="Cluster")
public class Cluster
extends ReceiverAdapter
implements Initializable,
Broadcast {
    private static Logger logger = Logger.getLogger();
    public static ObjectMapper mapper = ObjectMapperFactory.newInstance();
    private long broadcastPeriod = 30000L;
    private String name;
    private JChannel channel;
    private Map<String, List<Subscriber>> topicSubscribers = new Hashtable<String, List<Subscriber>>();
    private Map<Address, ClusterServices> members = new Hashtable<Address, ClusterServices>();
    private Map<String, Map<Address, ClusterService>> directory = new Hashtable<String, Map<Address, ClusterService>>();
    private ExecutorService threadPool;
    private ClusterServices myServices;
    private Balancer defaultBalancer = new LoadBalancer();
    private int adminPort;
    private String configFile = "udp.xml";

    public Cluster(String name) {
        this();
        this.name = name;
    }

    public Cluster() {
        try {
            this.myServices = new ClusterServices();
            this.myServices.getMember().setAdminPort(this.adminPort);
            this.myServices.getMember().setAddresses(Cluster.getHostAddresses());
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    @JmxAttributeMethod
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JmxAttributeMethod
    public String[] getMyServicesDescription() {
        ArrayList list = new ArrayList();
        this.myServices.getClusterServices().forEach(clusterService -> list.add(clusterService.toString()));
        return list.toArray(new String[list.size()]);
    }

    public ClusterServices getMyServices() {
        return this.myServices;
    }

    public Map<Address, ClusterServices> getMembers() {
        return Collections.unmodifiableMap(this.members);
    }

    @JmxAttributeMethod
    public String[] getMemberAddresses() {
        ArrayList<String> list = new ArrayList<String>();
        for (Address addr : this.members.keySet()) {
            list.add(addr.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    @JmxAttributeMethod
    public int getAdminPort() {
        return this.adminPort;
    }

    public void setAdminPort(int adminPort) {
        this.adminPort = adminPort;
    }

    @JmxAttributeMethod
    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void ExecutorService(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public ClusterService getClusterService(String name) {
        return this.getClusterService(name, null);
    }

    public ClusterService getClusterService(String name, Balancer balancer) {
        Map<Address, ClusterService> map;
        ArrayList<ClusterService> services = new ArrayList<ClusterService>();
        if (this.myServices.getClusterService(name) != null) {
            services.add(this.myServices.getClusterService(name));
        }
        if ((map = this.directory.get(name)) != null) {
            services.addAll(map.values());
        }
        if (balancer == null) {
            return this.defaultBalancer.select(services);
        }
        return balancer.select(services);
    }

    public List<ClusterService> getClusterServiceList(String name) {
        Map<Address, ClusterService> map;
        ArrayList<ClusterService> services = new ArrayList<ClusterService>();
        if (this.myServices.getClusterService(name) != null) {
            services.add(this.myServices.getClusterService(name));
        }
        if ((map = this.directory.get(name)) != null) {
            services.addAll(map.values());
        }
        return services;
    }

    public void addClusterService(ClusterService service) {
        this.myServices.addClusterService(service);
        if (this.channel != null && this.channel.isConnected()) {
            try {
                this.myServices.getMember().setUuid(this.channel.getView().getViewId().getCreator().toString());
                this.myServices.getMember().setAdminPort(this.adminPort);
                this.channel.send(null, (Object)this.myServices);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void initialize(Resources resources) {
        if (this.threadPool == null) {
            ThreadGroup group = Thread.currentThread().getThreadGroup();
            this.threadPool = Executors.newCachedThreadPool(runnable -> {
                Thread thread = new Thread(group, runnable, "Cluster");
                thread.setName("Cluster-" + thread.getId());
                thread.setDaemon(true);
                return thread;
            });
        }
        try {
            this.channel = new JChannel(this.configFile);
            this.channel.setReceiver((Receiver)this);
            this.channel.setDiscardOwnMessages(true);
            logger.info("Clustering, connecting with name=" + this.name);
            this.channel.connect(this.name);
            this.myServices.getMember().setUuid(this.channel.getView().getViewId().getCreator().toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.threadPool.execute(() -> {
            try {
                Thread.sleep(this.broadcastPeriod);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (true) {
                try {
                    this.channel.send(null, (Object)this.myServices);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    Thread.sleep(this.broadcastPeriod);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        });
        this.initSocketServer();
        JMXService.registerMBean((Object)((Object)this), (String)("net.e6tech:type=Cluster,name=" + this.name));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (Cluster.this.channel != null) {
                    try {
                        Cluster.this.channel.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        });
    }

    protected void initSocketServer() {
        try {
            ServerSocket server = new ServerSocket(this.adminPort);
            this.adminPort = server.getLocalPort();
            this.myServices.getMember().setAdminPort(this.adminPort);
            this.threadPool.execute(() -> {
                while (true) {
                    Socket socket = null;
                    try {
                        socket = server.accept();
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
                            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
                            String[] args = reader.readLine().split(",");
                            if (args == null || args.length <= 0) continue;
                            switch (args[0].trim()) {
                                case "services": {
                                    if (args.length <= 1) break;
                                    String name = args[1].trim();
                                    List<ClusterService> services = this.getClusterServiceList(name);
                                    String str = mapper.writeValueAsString((Object)services.toArray(new ClusterService[services.size()]));
                                    writer.write(str);
                                    writer.flush();
                                }
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Throwable e) {}
                    continue;
                    finally {
                        if (socket == null) continue;
                        try {
                            socket.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    break;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewAccepted(View newView) {
        List addresses = newView.getMembers();
        Hashtable<Address, ClusterServices> newTable = new Hashtable<Address, ClusterServices>();
        Hashtable<String, Map> newDirectory = new Hashtable<String, Map>();
        for (Address addr : addresses) {
            ClusterServices services = this.members.get(addr);
            if (services != null) {
                newTable.put(addr, services);
                for (ClusterService service : services.getClusterServices()) {
                    Map map = newDirectory.computeIfAbsent(service.getName(), key -> new Hashtable());
                    map.put(addr, service);
                }
                continue;
            }
            this.threadPool.execute(() -> {
                try {
                    this.channel.send(addr, (Object)this.myServices);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        Map<Address, ClusterServices> map = this.members;
        synchronized (map) {
            this.members.clear();
            this.members.putAll(newTable);
            this.directory.clear();
            this.directory.putAll(newDirectory);
        }
        logger.debug(this.members.toString());
    }

    public void receive(Message msg) {
        this.threadPool.execute(() -> {
            Object obj = msg.getObject();
            if (obj != null) {
                Address src = msg.getSrc();
                if (obj instanceof ClusterServices) {
                    Address self = this.channel.getAddress();
                    ClusterServices clusterServices = (ClusterServices)obj;
                    for (ClusterService service : clusterServices.getClusterServices()) {
                        Map map = this.directory.computeIfAbsent(service.getName(), key -> new Hashtable());
                        if (self.equals(msg.getDest())) continue;
                        map.put(src, service);
                    }
                    if (!self.equals(msg.getDest())) {
                        this.members.put(src, clusterServices);
                    }
                } else if (obj instanceof Notice) {
                    Notice notice = (Notice)obj;
                    String topic = notice.getTopic();
                    List<Subscriber> lis = this.topicSubscribers.get(topic);
                    if (lis != null) {
                        try {
                            lis.forEach(ml -> ml.receive(notice));
                        }
                        catch (Throwable th) {
                            logger.warn(th.getMessage(), th);
                        }
                    }
                } else {
                    System.out.println(msg.getSrc() + " " + obj);
                }
            }
        });
    }

    public Map<String, List<Subscriber>> getSubscribers() {
        return Collections.unmodifiableMap(this.topicSubscribers);
    }

    public void subscribe(String topic, Subscriber listener) {
        List subscriber = this.topicSubscribers.computeIfAbsent(topic, key -> new Vector());
        subscriber.add(listener);
    }

    public <T extends Serializable> void subscribe(Class<T> topic, Subscriber<T> listener) {
        this.subscribe(topic.getName(), listener);
    }

    public void unsubscribe(String topic, Subscriber subscriber) {
        List<Subscriber> sub = this.topicSubscribers.get(topic);
        if (sub != null) {
            sub.remove(subscriber);
        }
    }

    public void unsubscribe(Class topic, Subscriber subscriber) {
        this.unsubscribe(topic.getName(), subscriber);
    }

    public void publish(String topic, Serializable object) {
        this.threadPool.execute(() -> {
            try {
                this.channel.send(null, (Object)new Notice(topic, object));
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        });
    }

    public void publish(Class cls, Serializable object) {
        this.publish(cls.getName(), object);
    }

    public static InetAddress[] getHostAddresses() throws SocketException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
        for (NetworkInterface netint : Collections.list(nets)) {
            if (netint.isLoopback()) continue;
            Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
            for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
                addresses.add(inetAddress);
            }
        }
        return addresses.toArray(new InetAddress[addresses.size()]);
    }
}

