/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.shell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.e6tech.elements.common.logging.Logger;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class SshKeyDirectory {
    private static Logger logger = Logger.getLogger();
    private String directory;
    private Set<PublicKey> authorizedKeys = Collections.emptySet();
    private WatchService watcher;
    private Path path;
    private KeyFactory rsaKeyFactory;

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public Set<PublicKey> getAuthorizedKeys() {
        return this.authorizedKeys;
    }

    public void setAuthorizedKeys(Set<PublicKey> authorizedKeys) {
        this.authorizedKeys = authorizedKeys;
    }

    public boolean contains(PublicKey publicKey) {
        PublicKey pubKey = null;
        try {
            pubKey = this.normalizePublicKey(publicKey);
        }
        catch (GeneralSecurityException e) {
            return false;
        }
        if (pubKey == null) {
            return false;
        }
        this.poll();
        return this.authorizedKeys.contains(pubKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void poll() {
        WatchKey key = this.watcher.poll();
        while (key != null) {
            try {
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent<?> ev;
                    Path filename;
                    Path child;
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW || !Files.exists(child = this.path.resolve(filename = (Path)(ev = event).context()), new LinkOption[0]) || !child.getFileName().toString().endsWith(".pub")) continue;
                    try {
                        if (child.getFileName().toString().endsWith("pub")) {
                            this.loadSSHPubFile(child, this.authorizedKeys);
                            continue;
                        }
                        if (!child.getFileName().toString().endsWith("pem")) continue;
                        this.loadPEMFile(child, this.authorizedKeys);
                    }
                    catch (Exception e) {
                        logger.warn("Error reading " + child, (Throwable)e);
                    }
                }
            }
            finally {
                key.reset();
                key = this.watcher.poll();
            }
        }
    }

    public void init() throws Exception {
        this.rsaKeyFactory = KeyFactory.getInstance("RSA");
        if (this.directory == null) {
            throw new IllegalArgumentException("null ssh key path");
        }
        this.path = Paths.get(this.directory, new String[0]);
        if (Files.exists(this.path, new LinkOption[0])) {
            LinkedHashSet<PublicKey> keys = new LinkedHashSet<PublicKey>();
            if (Files.isRegularFile(this.path, new LinkOption[0])) {
                try {
                    this.loadSSHPubFile(this.path, keys);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.authorizedKeys = keys;
            } else if (Files.isDirectory(this.path, new LinkOption[0])) {
                Files.list(this.path).forEach(f -> {
                    if (Files.isRegularFile(f, new LinkOption[0]) && f.getFileName().toString().endsWith(".pub")) {
                        try {
                            if (f.getFileName().toString().endsWith(".pub")) {
                                this.loadSSHPubFile((Path)f, (Set<PublicKey>)keys);
                            } else if (f.getFileName().toString().endsWith(".pem")) {
                                this.loadPEMFile((Path)f, (Set<PublicKey>)keys);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                this.authorizedKeys = keys;
                try {
                    this.watcher = FileSystems.getDefault().newWatchService();
                    this.path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            throw new IllegalArgumentException(this.directory + " is not a valid path.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSSHPubFile(Path f, Set<PublicKey> keys) {
        BufferedReader reader = null;
        try {
            String line;
            reader = Files.newBufferedReader(f);
            while ((line = reader.readLine()) != null && line.trim().length() > 0) {
                try {
                    String[] components = line.split(" ");
                    byte[] bytes = Base64.getDecoder().decode(components[1]);
                    int index = 0;
                    BigInteger exponent = null;
                    BigInteger modulus = null;
                    for (int i = 0; i < 3; ++i) {
                        int length = bytes[index++] << 24 | bytes[index++] << 16 | bytes[index++] << 8 | bytes[index++];
                        byte[] content = new byte[length];
                        System.arraycopy(bytes, index, content, 0, length);
                        index += length;
                        if (i == 1) {
                            exponent = new BigInteger(content);
                            continue;
                        }
                        if (i != 2) continue;
                        modulus = new BigInteger(content);
                    }
                    RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus, exponent);
                    keys.add(this.normalizePublicKey(this.rsaKeyFactory.generatePublic(keySpec)));
                }
                catch (Exception ex) {
                    logger.warn("Cannot add public key in file " + f + ": " + ex.getMessage());
                }
            }
        }
        catch (Exception ex) {
            logger.warn("Cannot add public key in file " + f + ": " + ex.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private PublicKey normalizePublicKey(PublicKey publicKey) throws GeneralSecurityException {
        PublicKey pubKey = null;
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new GeneralSecurityException("Unsupported PublicKey format " + publicKey.getClass());
        }
        RSAPublicKeySpec pub = new RSAPublicKeySpec(((RSAPublicKey)publicKey).getModulus(), ((RSAPublicKey)publicKey).getPublicExponent());
        pubKey = this.rsaKeyFactory.generatePublic(pub);
        return pubKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPEMFile(Path f, Set<PublicKey> keys) {
        PEMParser pemParser = null;
        try {
            KeyPair keyPair;
            pemParser = new PEMParser((Reader)Files.newBufferedReader(f));
            Object o = pemParser.readObject();
            if (o instanceof KeyPair) {
                keyPair = new KeyPair(((KeyPair)o).getPublic(), null);
            } else if (o instanceof PublicKey) {
                keyPair = new KeyPair((PublicKey)o, null);
            } else if (o instanceof PEMKeyPair) {
                PEMKeyPair pemKeyPair = (PEMKeyPair)o;
                keyPair = this.convertPemKeyPair(pemKeyPair);
            } else if (o instanceof SubjectPublicKeyInfo) {
                PEMKeyPair pemKeyPair = new PEMKeyPair((SubjectPublicKeyInfo)o, null);
                keyPair = this.convertPemKeyPair(pemKeyPair);
            } else {
                throw new UnsupportedOperationException(String.format("Key type %s not supported.", o.getClass().getName()));
            }
            keys.add(this.normalizePublicKey(keyPair.getPublic()));
        }
        catch (Exception ex) {
            logger.warn("Cannot add public key in file " + f + ": " + ex.getMessage());
        }
        finally {
            if (pemParser != null) {
                try {
                    pemParser.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    KeyPair convertPemKeyPair(PEMKeyPair pemKeyPair) throws PEMException {
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        return new KeyPair(converter.getPublicKey(pemKeyPair.getPublicKeyInfo()), null);
    }
}

