/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.shell;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import net.e6tech.elements.network.shell.CustomSSHLifeCycle;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.server.keyprovider.PEMGeneratorHostKeyProvider;
import org.crsh.auth.AuthenticationPlugin;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.plugin.ResourceKind;
import org.crsh.ssh.SSHPlugin;
import org.crsh.ssh.term.URLKeyPairProvider;
import org.crsh.util.Utils;
import org.crsh.vfs.Resource;

public class CustomerSSHPlugin
extends SSHPlugin {
    private static final int SSH_SERVER_IDLE_DEFAULT_TIMEOUT = 600000;
    private static final int SSH_SERVER_AUTH_DEFAULT_TIMEOUT = 600000;
    private CustomSSHLifeCycle lifeCycle;

    public SSHPlugin getImplementation() {
        return this;
    }

    protected Iterable<PropertyDescriptor<?>> createConfigurationCapabilities() {
        return Arrays.asList(SSH_PORT, SSH_SERVER_KEYPATH, SSH_SERVER_KEYGEN, SSH_SERVER_AUTH_TIMEOUT, SSH_SERVER_IDLE_TIMEOUT, SSH_ENCODING, AuthenticationPlugin.AUTH);
    }

    public void init() {
        Charset encoding;
        String serverKeyPath;
        Resource serverKeyRes;
        Integer authTimeout;
        SecurityUtils.setRegisterBouncyCastle((boolean)true);
        Integer port = (Integer)this.getContext().getProperty(SSH_PORT);
        if (port == null) {
            this.log.log(Level.INFO, "Could not boot SSHD due to missing due to missing port configuration");
            return;
        }
        Integer idleTimeout = (Integer)this.getContext().getProperty(SSH_SERVER_IDLE_TIMEOUT);
        if (idleTimeout == null) {
            idleTimeout = 600000;
        }
        if ((authTimeout = (Integer)this.getContext().getProperty(SSH_SERVER_AUTH_TIMEOUT)) == null) {
            authTimeout = 600000;
        }
        Resource serverKey = null;
        URLKeyPairProvider keyPairProvider = null;
        URL serverKeyURL = SSHPlugin.class.getResource("/crash/hostkey.pem");
        if (serverKeyURL != null) {
            try {
                this.log.log(Level.FINE, "Found embedded key url " + serverKeyURL);
                serverKey = new Resource("hostkey.pem", serverKeyURL);
            }
            catch (IOException e) {
                this.log.log(Level.FINE, "Could not load ssh key from url " + serverKeyURL, e);
            }
        }
        if ((serverKeyRes = this.getContext().loadResource("hostkey.pem", ResourceKind.CONFIG)) != null) {
            serverKey = serverKeyRes;
            this.log.log(Level.FINE, "Found server ssh key url");
        }
        if ((serverKeyPath = (String)this.getContext().getProperty(SSH_SERVER_KEYPATH)) != null) {
            this.log.log(Level.FINE, "Found server key path " + serverKeyPath);
            File f = new File(serverKeyPath);
            String keyGen = (String)this.getContext().getProperty(SSH_SERVER_KEYGEN);
            if (keyGen != null && keyGen.equals("true")) {
                keyPairProvider = new PEMGeneratorHostKeyProvider(serverKeyPath, "RSA");
            } else if (f.exists() && f.isFile()) {
                try {
                    serverKeyURL = f.toURI().toURL();
                    serverKey = new Resource("hostkey.pem", serverKeyURL);
                }
                catch (MalformedURLException e) {
                    this.log.log(Level.FINE, "Ignoring invalid server key " + serverKeyPath, e);
                }
                catch (IOException e) {
                    this.log.log(Level.FINE, "Could not load SSH key from " + serverKeyPath, e);
                }
            } else {
                this.log.log(Level.FINE, "Ignoring invalid server key path " + serverKeyPath);
            }
        }
        if (serverKeyURL == null) {
            this.log.log(Level.INFO, "Could not boot SSHD due to missing server key");
            return;
        }
        if (keyPairProvider == null) {
            keyPairProvider = new URLKeyPairProvider(serverKey);
        }
        ArrayList<AuthenticationPlugin> authPlugins = new ArrayList<AuthenticationPlugin>(0);
        List authentication = (List)this.getContext().getProperty(AuthenticationPlugin.AUTH);
        if (authentication != null) {
            for (AuthenticationPlugin authenticationPlugin : this.getContext().getPlugins(AuthenticationPlugin.class)) {
                if (!authentication.contains(authenticationPlugin.getName())) continue;
                authPlugins.add(authenticationPlugin);
            }
        }
        if ((encoding = (Charset)this.getContext().getProperty(SSH_ENCODING)) == null) {
            encoding = Utils.UTF_8;
        }
        this.log.log(Level.INFO, "Booting SSHD");
        CustomSSHLifeCycle lifeCycle = new CustomSSHLifeCycle(this.getContext(), encoding, port, idleTimeout, authTimeout, (KeyPairProvider)keyPairProvider, authPlugins);
        lifeCycle.init();
        this.lifeCycle = lifeCycle;
    }

    public void destroy() {
        if (this.lifeCycle != null) {
            this.log.log(Level.INFO, "Shutting down SSHD");
            this.lifeCycle.destroy();
            this.lifeCycle = null;
        }
    }
}

