/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.clustering;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import net.e6tech.elements.common.serialization.ObjectMapperFactory;
import net.e6tech.elements.network.clustering.Balancer;
import net.e6tech.elements.network.clustering.ClusterService;
import net.e6tech.elements.network.clustering.LoadBalancer;

public class ClusterClient {
    public static ObjectMapper mapper = ObjectMapperFactory.newInstance();
    static final String SERVICES_CMD = "services";
    private long firstContact = 10000L;
    private long renewalPeriod = 60000L;
    private List<ClusterService> services = new ArrayList<ClusterService>();
    private String host;
    private int adminPort;
    private String serviceName;
    private ClusterService current;
    private Thread renewalThread;
    private Renewal renewal;
    private Balancer balancer = new LoadBalancer();

    public long getRenewalPeriod() {
        return this.renewalPeriod;
    }

    public void setRenewalPeriod(long renewalPeriod) {
        this.renewalPeriod = renewalPeriod;
    }

    public List<ClusterService> getServices() {
        return this.services;
    }

    public void setServices(List<ClusterService> services) {
        this.services = services;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public void setAdminPort(int adminPort) {
        this.adminPort = adminPort;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public synchronized void connect(String clusterAddress) {
        if (clusterAddress == null) {
            return;
        }
        this.stop();
        String host = clusterAddress.substring(0, clusterAddress.indexOf(":"));
        if (host == null || host.length() == 0) {
            throw new IllegalArgumentException("Null cluster host");
        }
        int port = Integer.parseInt(clusterAddress.substring(clusterAddress.indexOf(":") + 1, clusterAddress.indexOf("/")));
        String serviceName = clusterAddress.substring(clusterAddress.indexOf("/") + 1);
        while (serviceName.startsWith("/")) {
            serviceName = serviceName.substring(1);
        }
        if (serviceName == null || serviceName.length() == 0) {
            throw new IllegalArgumentException("Null cluster serviceName");
        }
        this.setAdminPort(port);
        this.setServiceName(serviceName);
        this.setHost(host);
        this.start();
    }

    public ClusterService select() {
        return this.balancer.select(this.services);
    }

    public synchronized void stop() {
        if (this.renewalThread != null) {
            this.renewal.stopped = true;
            this.renewalThread.interrupt();
            this.renewal = null;
            this.renewalThread = null;
        }
    }

    public void start() {
        if (this.renewalThread != null) {
            return;
        }
        this.renewal = new Renewal();
        this.renewalThread = new Thread(this.renewal);
        this.renewalThread.setDaemon(true);
        this.renewalThread.start();
    }

    protected void renewal() throws IOException {
        while (true) {
            Socket socket = null;
            try {
                socket = this.selectSocket();
            }
            catch (IOException ex) {
                if (this.current != null) {
                    this.current.setHealthy(false);
                }
                throw ex;
            }
            try {
                this._renewal(socket);
            }
            catch (IOException ex) {
                if (this.current != null) {
                    this.current.setHealthy(false);
                    continue;
                }
                throw ex;
            }
            finally {
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            break;
        }
    }

    protected void _renewal(Socket socket) throws IOException {
        if (socket == null) {
            return;
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
        writer.write("services," + this.serviceName + "\n");
        writer.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
        ClusterService[] list = (ClusterService[])mapper.readValue((Reader)reader, ClusterService[].class);
        this.services.clear();
        for (ClusterService cs : list) {
            this.services.add(cs);
        }
    }

    protected Socket selectSocket() throws IOException {
        if (this.services.size() == 0) {
            this.current = null;
            return new Socket(this.host, this.adminPort);
        }
        for (ClusterService cs : this.services) {
            if (!cs.isHealthy()) continue;
            try {
                this.current = cs;
                return new Socket(cs.getMember().getAddresses()[0], cs.getMember().getAdminPort());
            }
            catch (IOException | NullPointerException ex) {
                cs.setHealthy(false);
            }
        }
        this.current = null;
        return new Socket(this.host, this.adminPort);
    }

    class Renewal
    implements Runnable {
        boolean stopped = false;

        Renewal() {
        }

        @Override
        public void run() {
            int count = 0;
            while (!this.stopped) {
                try {
                    ClusterClient.this.renewal();
                    break;
                }
                catch (IOException iOException) {
                    ++count;
                    try {
                        if (count <= 6) {
                            Thread.sleep(ClusterClient.this.firstContact);
                        } else {
                            Thread.sleep((long)(count - 5) * ClusterClient.this.firstContact);
                        }
                        if (count != 10) continue;
                        count = 6;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            try {
                Thread.sleep(ClusterClient.this.renewalPeriod);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (!this.stopped) {
                try {
                    ClusterClient.this.renewal();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    boolean healthy = false;
                    for (ClusterService cs : ClusterClient.this.services) {
                        if (!cs.isHealthy()) continue;
                        healthy = true;
                        break;
                    }
                    if (healthy) {
                        Thread.sleep(ClusterClient.this.renewalPeriod);
                        continue;
                    }
                    Thread.sleep(ClusterClient.this.firstContact);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

