/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.shell;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import net.e6tech.elements.network.shell.ClassPathMountFactory;
import net.e6tech.elements.network.shell.CustomShellFactory;
import net.e6tech.elements.network.shell.CustomerSSHPlugin;
import net.e6tech.elements.network.shell.PasswordAuthenticationPlugin;
import net.e6tech.elements.network.shell.PluginDiscovery;
import net.e6tech.elements.network.shell.SshKeyAuthenticationPlugin;
import net.e6tech.elements.security.SymmetricCipher;
import org.crsh.console.jline.JLineProcessor;
import org.crsh.console.jline.Terminal;
import org.crsh.console.jline.TerminalFactory;
import org.crsh.console.jline.console.ConsoleReader;
import org.crsh.console.jline.internal.Configuration;
import org.crsh.plugin.Embedded;
import org.crsh.plugin.PluginContext;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellFactory;
import org.crsh.shell.impl.command.CRaSHShellFactory;
import org.crsh.ssh.SSHPlugin;
import org.crsh.telnet.TelnetPlugin;
import org.crsh.util.InterruptHandler;
import org.crsh.util.Utils;
import org.crsh.vfs.spi.FSMountFactory;
import org.crsh.vfs.spi.file.FileMountFactory;
import org.fusesource.jansi.AnsiConsole;

public class Shelld
extends Embedded {
    protected ClassLoader classLoader;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    protected final HashMap<String, FSMountFactory<?>> drivers = new HashMap();
    private String cmdMountPointConfig;
    private String confMountPointConfig;
    private String propertiesFile;
    private Properties properties;
    private Set<String> excludes = new LinkedHashSet<String>();
    private Set<String> includes = new LinkedHashSet<String>();
    private Set<String> commandPaths = new LinkedHashSet<String>();
    private String fileRootDir;
    private PluginContext context;
    private int sshPort = -1;
    private int sshAuthTimeout = 300000;
    private int sshIdleTimeout = 300000;
    private int telnetPort = -1;

    public static void main(String ... args) throws Exception {
        Shelld shelld = new Shelld();
        shelld.addCmdClassPath("net/e6tech/elements/network/shell/commands").telnetPort(5000).sshPort(2000).start();
    }

    public Shelld sshPort(int port) {
        this.sshPort = port;
        return this;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
    }

    public int getSshAuthTimeout() {
        return this.sshAuthTimeout;
    }

    public void setSshAuthTimeout(int sshAuthTimeout) {
        this.sshAuthTimeout = sshAuthTimeout;
    }

    public int getSshIdleTimeout() {
        return this.sshIdleTimeout;
    }

    public void setSshIdleTimeout(int sshIdleTimeout) {
        this.sshIdleTimeout = sshIdleTimeout;
    }

    public Shelld telnetPort(int port) {
        this.telnetPort = port;
        return this;
    }

    public int getTelnetPort() {
        return this.telnetPort;
    }

    public void setTelnetPort(int telnetPort) {
        this.telnetPort = telnetPort;
    }

    public void addAttribute(String name, Object object) {
        this.attributes.put(name, object);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public List<String> getExcludes() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.excludes);
        return Collections.unmodifiableList(list);
    }

    public void setExcludes(List<String> excludes) {
        this.excludes.clear();
        this.excludes.addAll(excludes);
    }

    public List<String> getIncludes() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.includes);
        return Collections.unmodifiableList(list);
    }

    public void setIncludes(List<String> includes) {
        this.includes.clear();
        this.includes.addAll(includes);
    }

    public void includePlugins(String ... plugins) {
        this.mergePlugins(this.includes, this.excludes, plugins);
    }

    public void excludePlugins(String ... plugins) {
        this.mergePlugins(this.excludes, this.includes, plugins);
    }

    protected void mergePlugins(Set<String> add, Set<String> remove, String ... plugins) {
        if (plugins != null) {
            for (String p : plugins) {
                if (!add.contains(p)) {
                    add.add(p);
                }
                remove.remove(p);
            }
        }
    }

    public List<String> getCommandPaths() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.commandPaths);
        return Collections.unmodifiableList(list);
    }

    public void setCommandPaths(List<String> commandPaths) {
        this.commandPaths.clear();
        this.commandPaths.addAll(commandPaths);
    }

    public Shelld addCmdClassPath(String path) {
        this.commandPaths.add(path);
        return this;
    }

    public Shelld fileRootDir(String dir) {
        this.fileRootDir = dir;
        return this;
    }

    public String getFileRootDir() {
        return this.fileRootDir;
    }

    public void setFileRootDir(String fileRootDir) {
        this.fileRootDir = fileRootDir;
    }

    public Shelld propertiesFile(String fileName) {
        this.propertiesFile = fileName;
        return this;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void start() throws Exception {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : ((Object)((Object)this)).getClass().getClassLoader();
        }
        Properties config = new Properties();
        if (this.propertiesFile != null) {
            config.load(new FileReader(this.propertiesFile));
        }
        if (this.properties != null) {
            config.putAll((Map<?, ?>)this.properties);
        }
        if (this.sshPort <= 0 && config.containsKey("crash.ssh.port")) {
            this.sshPort = Integer.parseInt(config.getProperty("crash.ssh.port"));
        }
        if (config.containsKey("crash.vfs.refresh_period")) {
            config.setProperty("crash.vfs.refresh_period", "1");
        }
        this.excludePlugins(SSHPlugin.class.getName());
        if (this.sshPort > 0) {
            config.setProperty("crash.ssh.port", "" + this.sshPort);
            if (!config.containsKey("crash.ssh.auth_timeout")) {
                config.setProperty("crash.ssh.auth_timeout", "" + this.sshAuthTimeout);
            }
            if (!config.containsKey("crash.ssh.idle_timeout")) {
                config.setProperty("crash.ssh.idle_timeout", "" + this.sshIdleTimeout);
            }
            this.includePlugins(CustomerSSHPlugin.class.getName());
            this.includePlugins(SshKeyAuthenticationPlugin.class.getName());
        }
        if (this.telnetPort <= 0 && config.containsKey("crash.telnet.port")) {
            this.telnetPort = Integer.parseInt(config.getProperty("crash.telnet.port"));
        }
        if (this.telnetPort > 0) {
            config.setProperty("crash.telnet.port", "" + this.telnetPort);
        } else {
            this.excludePlugins(TelnetPlugin.class.getName());
        }
        this.includePlugins(PasswordAuthenticationPlugin.class.getName());
        this.excludePlugins(CRaSHShellFactory.class.getName());
        this.includePlugins(CustomShellFactory.class.getName());
        this.setConfig(config);
        try {
            File rootDir = Utils.getCurrentDirectory();
            if (this.fileRootDir != null) {
                rootDir = new File(this.fileRootDir);
            }
            ClassPathMountFactory classPathMountFactory = new ClassPathMountFactory(this.classLoader);
            FileMountFactory fileMountFactory = new FileMountFactory(rootDir);
            this.drivers.put("classpath", classPathMountFactory);
            this.drivers.put("file", (FSMountFactory<?>)fileMountFactory);
            this.commandPaths.forEach(path -> classPathMountFactory.addCommandPath((String)path));
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Could not initialize classpath driver", e);
            return;
        }
        PluginDiscovery discovery = new PluginDiscovery(this.classLoader);
        for (String exclude : this.excludes) {
            discovery.removePlugin(exclude);
        }
        for (String include : this.includes) {
            discovery.addPlugin(include);
        }
        this.context = this.start(Collections.unmodifiableMap(this.attributes), (org.crsh.plugin.PluginDiscovery)discovery, this.classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public Shelld cmdMountPointConfig(String mountPoint) {
        this.cmdMountPointConfig = mountPoint;
        return this;
    }

    public String getCmdMountPointConfig() {
        return this.cmdMountPointConfig;
    }

    public void setCmdMountPointConfig(String cmdMountPointConfig) {
        this.cmdMountPointConfig = cmdMountPointConfig;
    }

    public Shelld confMountPointConfig(String mountPoint) {
        this.confMountPointConfig = mountPoint;
        return this;
    }

    public String getConfMountPointConfig() {
        return this.confMountPointConfig;
    }

    public void setConfMountPointConfig(String confMountPointConfig) {
        this.confMountPointConfig = confMountPointConfig;
    }

    protected Map<String, FSMountFactory<?>> getMountFactories() {
        return this.drivers;
    }

    protected String resolveConfMountPointConfig() {
        return this.confMountPointConfig != null ? this.confMountPointConfig : this.getDefaultConfMountPointConfig();
    }

    protected String resolveCmdMountPointConfig() {
        return this.cmdMountPointConfig != null ? this.cmdMountPointConfig : this.getDefaultCmdMountPointConfig();
    }

    protected String getDefaultCmdMountPointConfig() {
        return "classpath:/crash/commands/";
    }

    protected String getDefaultConfMountPointConfig() {
        return "classpath:/crash/";
    }

    public void destroy() throws Exception {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interactive() throws IOException {
        ShellFactory factory = (ShellFactory)this.context.getPlugin(ShellFactory.class);
        Shell shell = factory.create(null);
        if (shell != null) {
            boolean ansi;
            PrintStream out;
            final Terminal term = TerminalFactory.create();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        term.restore();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            String encoding = Configuration.getEncoding();
            if (term.isAnsiSupported()) {
                out = new PrintStream((OutputStream)new BufferedOutputStream(term.wrapOutIfNeeded((OutputStream)new FileOutputStream(FileDescriptor.out)), 16384), false, encoding);
                PrintStream err = new PrintStream((OutputStream)new BufferedOutputStream(term.wrapOutIfNeeded((OutputStream)new FileOutputStream(FileDescriptor.err)), 16384), false, encoding);
                ansi = true;
            } else {
                out = AnsiConsole.out;
                PrintStream err = AnsiConsole.err;
                ansi = false;
            }
            FileInputStream in = new FileInputStream(FileDescriptor.in);
            ConsoleReader reader = new ConsoleReader(null, (InputStream)in, (OutputStream)out, term);
            final JLineProcessor processor = new JLineProcessor(ansi, shell, reader, out);
            InterruptHandler interruptHandler = new InterruptHandler(new Runnable(){

                @Override
                public void run() {
                    processor.interrupt();
                }
            });
            interruptHandler.install();
            Thread thread = new Thread((Runnable)processor);
            thread.setDaemon(true);
            thread.start();
            try {
                processor.closed();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    static {
        SymmetricCipher.initialize();
    }
}

