/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.restful;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.interceptor.InterceptorHandler;
import net.e6tech.elements.network.restful.Param;
import net.e6tech.elements.network.restful.Request;
import net.e6tech.elements.network.restful.Response;
import net.e6tech.elements.network.restful.RestfulClient;
import net.e6tech.elements.network.restful.WSResponseImpl;

public class RestfulProxy {
    private String hostAddress;
    private RestfulClient client;
    private Interceptor interceptor;
    private Map<String, String> requestProperties = new LinkedHashMap<String, String>();
    private PrintWriter printer;

    public RestfulProxy(String hostAddress) {
        this.hostAddress = hostAddress;
        this.client = new RestfulClient(hostAddress);
        this.interceptor = Interceptor.getInstance();
    }

    public PrintWriter getPrinter() {
        return this.printer;
    }

    public void setPrinter(PrintWriter printer) {
        this.printer = printer;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    public boolean isSkipHostnameCheck() {
        return this.client.isSkipHostnameCheck();
    }

    public void setSkipHostnameCheck(boolean skipHostnameCheck) {
        this.client.setSkipHostnameCheck(skipHostnameCheck);
    }

    public boolean isSkipCertCheck() {
        return this.client.isSkipCertCheck();
    }

    public void setSkipCertCheck(boolean skipCertCheck) {
        this.client.setSkipCertCheck(skipCertCheck);
    }

    public <T> T newProxy(Class<T> serviceClass) {
        this.client.setPrinter(this.printer);
        return (T)this.interceptor.newInstance(serviceClass, (InterceptorHandler)new InvocationHandler(this, serviceClass, this.printer));
    }

    public void setRequestProperty(String key, String value) {
        this.requestProperties.put(key, value);
    }

    public void clearRequestProperty(String key) {
        this.requestProperties.remove(key);
    }

    public void clearAllRequestProperties() {
        this.requestProperties.clear();
    }

    private static class MethodForwarder {
        boolean get;
        boolean post;
        boolean put;
        boolean delete;
        Class returnType;
        ParameterizedType parameterizedReturnType;
        Class[] paramTypes;
        Parameter[] params;
        String context;
        QueryParam[] queryParams;
        PathParam[] pathParams;

        MethodForwarder(String context, Method method) {
            this.returnType = method.getReturnType();
            if (method.getGenericReturnType() instanceof ParameterizedType) {
                this.parameterizedReturnType = (ParameterizedType)method.getGenericReturnType();
            }
            this.paramTypes = method.getParameterTypes();
            this.context = context;
            this.queryParams = new QueryParam[this.paramTypes.length];
            this.pathParams = new PathParam[this.paramTypes.length];
            int idx = 0;
            for (Parameter param : this.params = method.getParameters()) {
                QueryParam queryParam = param.getAnnotation(QueryParam.class);
                PathParam pathParam = param.getAnnotation(PathParam.class);
                if (queryParam != null) {
                    this.queryParams[idx] = queryParam;
                }
                if (pathParam != null) {
                    this.pathParams[idx] = pathParam;
                }
                ++idx;
            }
            if (method.getAnnotation(POST.class) != null) {
                this.post = true;
            } else if (method.getAnnotation(PUT.class) != null) {
                this.put = true;
            } else if (method.getAnnotation(GET.class) != null) {
                this.get = true;
            } else if (method.getAnnotation(DELETE.class) != null) {
                this.delete = true;
            } else {
                throw new IllegalArgumentException("Method " + method + " is not annotated with GET, PUT, POST or DELETE.");
            }
        }

        Object forward(Request request, Object[] args) throws Throwable {
            Class encloseType;
            Type type;
            ArrayList<Param> paramList = new ArrayList<Param>();
            Object postData = null;
            String fullContext = this.context;
            for (int i = 0; i < this.paramTypes.length; ++i) {
                if (this.queryParams[i] != null && args[i] != null) {
                    Param p = new Param(this.queryParams[i].value(), args[i].toString());
                    paramList.add(p);
                }
                if (this.pathParams[i] != null) {
                    if (args[i] == null) {
                        throw new IllegalArgumentException("PathParam {" + this.pathParams[i].value() + "} cannot be null");
                    }
                    String value = args[i].toString();
                    String valueEscaped = URLEncoder.encode(value, "UTF-8").replaceAll("\\+", "%20");
                    fullContext = fullContext.replace("{" + this.pathParams[i].value() + "}", valueEscaped);
                }
                if (this.pathParams[i] != null || this.queryParams[i] != null) continue;
                postData = args[i];
            }
            Response response = null;
            if (this.post) {
                response = request.post(fullContext, postData, paramList.toArray(new Param[paramList.size()]));
            } else if (this.put) {
                response = request.put(fullContext, postData, paramList.toArray(new Param[paramList.size()]));
            } else if (this.get) {
                response = request.get(fullContext, paramList.toArray(new Param[paramList.size()]));
            } else if (this.delete) {
                response = request.delete(fullContext, paramList.toArray(new Param[paramList.size()]));
            }
            if (javax.ws.rs.core.Response.class.isAssignableFrom(this.returnType)) {
                WSResponseImpl impl = new WSResponseImpl(response);
                return impl;
            }
            if (this.returnType.equals(Void.TYPE)) {
                return null;
            }
            if (this.parameterizedReturnType != null && (type = this.parameterizedReturnType.getRawType()) instanceof Class && Collection.class.isAssignableFrom(encloseType = (Class)type)) {
                Class elementType = (Class)this.parameterizedReturnType.getActualTypeArguments()[0];
                CollectionType ctype = TypeFactory.defaultInstance().constructCollectionType(encloseType, elementType);
                return Response.mapper.readValue(response.getResult(), (JavaType)ctype);
            }
            return response.read(this.returnType);
        }

        private Collection convertCollection(Collection value, Class<? extends Collection> collectionType, Class elementType) throws IOException {
            return null;
        }
    }

    private static class InvocationHandler
    implements InterceptorHandler {
        private RestfulProxy proxy;
        private String context;
        private Map<Method, MethodForwarder> methodForwarders = new Hashtable<Method, MethodForwarder>();
        private PrintWriter printer;

        InvocationHandler(RestfulProxy proxy, Class serviceClass, PrintWriter printer) {
            this.proxy = proxy;
            this.printer = printer;
            Path path = serviceClass.getAnnotation(Path.class);
            if (path != null) {
                this.context = path.value();
                if (!this.context.endsWith("/")) {
                    this.context = path.value() + "/";
                }
            } else {
                this.context = "/";
            }
        }

        public Object invoke(Object aProxy, Method thisMethod, Object target, Method proceed, Object[] args) throws Throwable {
            if (this.printer != null) {
                this.printer.println(thisMethod);
            }
            Request request = this.proxy.client.create();
            for (Map.Entry entry : this.proxy.requestProperties.entrySet()) {
                request.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            String fullContext = this.context;
            Path path = thisMethod.getAnnotation(Path.class);
            if (path != null) {
                String subctx = path.value();
                while (subctx.startsWith("/")) {
                    subctx = subctx.substring(1);
                }
                fullContext = this.context + subctx;
            }
            String ctx = fullContext;
            MethodForwarder forwarder = this.methodForwarders.computeIfAbsent(thisMethod, key -> new MethodForwarder(ctx, (Method)key));
            return forwarder.forward(request, args);
        }
    }
}

