/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.jobs;

import com.j256.simplejmx.common.JmxAttributeMethod;
import com.j256.simplejmx.common.JmxOperation;
import com.j256.simplejmx.common.JmxResource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import net.e6tech.elements.common.launch.LaunchListener;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.Startable;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.jobs.JobServer;
import org.quartz.CronTrigger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.triggers.CronTriggerImpl;

@JmxResource(description="Job", domainName="Jobs")
public class Job
implements Initializable,
Startable,
LaunchListener {
    private static Logger logger = Logger.getLogger();
    private JobServer jobServer;
    private Scheduler scheduler;
    private String name;
    private String group = "default";
    private String cronExpression;
    private int priority = 5;
    private TimeZone timezone = TimeZone.getDefault();
    private long initialDelay = 0L;
    private boolean concurrent = false;
    private Method invocation;
    private Object target;
    private String targetMethod;
    private AtomicInteger running = new AtomicInteger(0);
    private boolean started = false;

    public JobServer getJobServer() {
        return this.jobServer;
    }

    public void setJobServer(JobServer jobServer) {
        this.jobServer = jobServer;
    }

    @JmxOperation
    public void stop() throws SchedulerException {
        this.scheduler.deleteJob(new JobKey(this.name, this.group));
    }

    @JmxOperation
    public void resume() throws SchedulerException {
        if (this.scheduler.getJobDetail(new JobKey(this.name, this.group)) != null) {
            CronTriggerImpl trigger = (CronTriggerImpl)this.scheduler.getTrigger(new TriggerKey(this.name, this.group));
            if (trigger != null) {
                this.scheduler.resumeTrigger(new TriggerKey(this.name, this.group));
            }
        } else {
            JobDetail jobDetail = this.newJobDetail();
            CronTriggerImpl trigger = (CronTriggerImpl)this.scheduler.getTrigger(new TriggerKey(this.name, this.group));
            try {
                if (trigger != null) {
                    this.updateTrigger(trigger);
                } else {
                    trigger = this.newCronTrigger();
                }
            }
            catch (ParseException ex) {
                throw new SchedulerException((Throwable)ex);
            }
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
    }

    @JmxOperation
    public void reschedule(String cronExpression) throws SchedulerException {
        this.setCronExpression(cronExpression);
        this.stop();
        this.resume();
    }

    @JmxAttributeMethod
    public String getNextFireTime() {
        try {
            Trigger trigger = this.scheduler.getTrigger(new TriggerKey(this.name, this.group));
            return trigger.getNextFireTime().toString();
        }
        catch (SchedulerException e) {
            Logger.suppress((Throwable)e);
        }
        catch (Exception th) {
            Logger.suppress((Throwable)th);
        }
        return "NA";
    }

    @JmxAttributeMethod
    public boolean isRunning() {
        try {
            JobDetail detail = this.scheduler.getJobDetail(new JobKey(this.name, this.group));
            if (detail == null) {
                return false;
            }
            return this.running.get() > 0;
        }
        catch (Exception th) {
            Logger.suppress((Throwable)th);
            return false;
        }
    }

    private void init() {
        try {
            if (this.target instanceof Class) {
                this.target = ((Class)this.target).newInstance();
            }
            this.invocation = this.target.getClass().getMethod(this.targetMethod, new Class[0]);
        }
        catch (Exception e) {
            throw logger.systemException((Throwable)e);
        }
    }

    public void initialize(Resources resources) {
    }

    public void start() {
        if (this.started) {
            return;
        }
        try {
            logger.info("Scheduled job={}", (Object)this.getName());
            this.init();
            JobDetail jobDetail = this.newJobDetail();
            CronTriggerImpl trigger = this.newCronTrigger();
            if (this.jobServer != null) {
                this.scheduler = this.jobServer.getScheduler();
            } else if (this.scheduler == null) {
                StdSchedulerFactory factory = new StdSchedulerFactory();
                this.scheduler = factory.getScheduler();
                this.scheduler.start();
            }
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            this.started = true;
        }
        catch (Exception ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public void launched(Provision provision) {
    }

    protected JobDetail newJobDetail() {
        Class jobClass = this.concurrent ? ConcurrentRunner.class : NonConcurrentRunner.class;
        JobDetailImpl jobDetail = new JobDetailImpl();
        jobDetail.setName(this.name);
        jobDetail.setGroup(this.group);
        jobDetail.setJobClass(jobClass);
        jobDetail.getJobDataMap().put("job", (Object)this);
        jobDetail.setDurability(true);
        return jobDetail;
    }

    protected CronTriggerImpl newCronTrigger() throws ParseException {
        CronTriggerImpl trigger = new CronTriggerImpl();
        this.updateTrigger(trigger);
        return trigger;
    }

    protected CronTrigger updateTrigger(CronTriggerImpl trigger) throws ParseException {
        trigger.setName(this.name);
        trigger.setGroup(this.group);
        trigger.setCronExpression(this.cronExpression);
        trigger.setPriority(this.priority);
        trigger.setTimeZone(this.timezone);
        trigger.setStartTime(new Date(System.currentTimeMillis() + this.initialDelay));
        return trigger;
    }

    public Object execute() throws Throwable {
        try {
            this.running.incrementAndGet();
            if (this.jobServer != null && this.jobServer.resourceManager != null) {
                this.jobServer.resourceManager.createLoggerContext();
            }
            Object object = this.invocation.invoke(this.target, new Object[0]);
            return object;
        }
        catch (InvocationTargetException ex) {
            Logger.suppress((Throwable)ex);
            throw ex.getTargetException();
        }
        finally {
            this.running.decrementAndGet();
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @JmxAttributeMethod
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JmxAttributeMethod
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @JmxAttributeMethod
    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    @JmxAttributeMethod
    public int getPriority() {
        return this.priority;
    }

    @JmxAttributeMethod
    public void setPriority(int priority) {
        this.priority = priority;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
    }

    @JmxAttributeMethod
    public long getInitialDelay() {
        return this.initialDelay;
    }

    @JmxAttributeMethod
    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    @JmxAttributeMethod
    public boolean isConcurrent() {
        return this.concurrent;
    }

    @JmxAttributeMethod
    public void setConcurrent(boolean concurrent) {
        this.concurrent = concurrent;
    }

    public Method getInvocation() {
        return this.invocation;
    }

    public void setInvocation(Method invocation) {
        this.invocation = invocation;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public String getTargetMethod() {
        return this.targetMethod;
    }

    public void setTargetMethod(String targetMethod) {
        this.targetMethod = targetMethod;
    }

    @PersistJobDataAfterExecution
    @DisallowConcurrentExecution
    public static class NonConcurrentRunner
    extends ConcurrentRunner {
    }

    public static class ConcurrentRunner
    implements org.quartz.Job {
        Job job;

        public void setJob(Job job) {
            this.job = job;
        }

        public void execute(JobExecutionContext context) throws JobExecutionException {
            try {
                context.setResult(this.job.execute());
            }
            catch (Throwable e) {
                throw new JobExecutionException(e);
            }
        }
    }
}

