/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.jobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.jmx.JMXService;
import net.e6tech.elements.jobs.Job;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class JobServer {
    private static Logger logger = Logger.getLogger();
    private Map<String, Job> jobs = new LinkedHashMap<String, Job>();
    Scheduler scheduler;
    @Inject
    ResourceManager resourceManager;

    public List<String> listJobs() {
        ArrayList<String> list = new ArrayList<String>(this.jobs.keySet().size());
        list.addAll(this.jobs.keySet());
        return list;
    }

    public Map<String, Job> getJobs() {
        return Collections.unmodifiableMap(this.jobs);
    }

    public Job getJob(String jobName) {
        return this.jobs.get(jobName);
    }

    public Scheduler getScheduler() {
        if (this.scheduler == null) {
            StdSchedulerFactory factory = new StdSchedulerFactory();
            try {
                this.scheduler = factory.getScheduler();
                this.scheduler.start();
            }
            catch (SchedulerException e) {
                e.printStackTrace();
            }
        }
        return this.scheduler;
    }

    public Job registerJob(String name, Object target) {
        Job job = (Job)this.resourceManager.registerBean(name, Job.class);
        job.setJobServer(this);
        Object instance = target;
        if (target instanceof Class) {
            instance = this.resourceManager.newInstance((Class)target);
        }
        JMXService.registerMBean((Object)instance, (String)("net.e6tech:type=JobTarget,name=" + name));
        job.setTarget(instance);
        job.setScheduler(this.getScheduler());
        job.setName(name);
        JMXService.registerMBean((Object)job, (String)("net.e6tech:type=Job,name=" + name));
        this.jobs.put(name, job);
        return job;
    }
}

