/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.jmx;

import com.j256.simplejmx.common.JmxResource;
import com.j256.simplejmx.server.JmxServer;
import com.sun.jdmk.comm.AuthInfo;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MXBean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.ObjectConverter;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.jmx.JMXHtmlServer;

public class JMXService {
    private static final Logger logger = Logger.getLogger();

    private JMXService() {
    }

    public static void start(int port, int jmxrmiPort, String user, char[] password) throws Exception {
        JMXService.start(InetAddress.getLoopbackAddress(), port, jmxrmiPort, user, password);
    }

    public static void start(InetAddress bindAddress, int port, int jmxrmiPort, String user, char[] password) throws Exception {
        if (port >= 0) {
            JMXHtmlServer adapter = new JMXHtmlServer(port);
            adapter.setBindAddress(bindAddress);
            if (user != null && user.length() > 0) {
                AuthInfo authInfo = new AuthInfo(user, new String(password));
                adapter.addUserAuthenticationInfo(authInfo);
            }
            adapter.start();
            try {
                ManagementFactory.getPlatformMBeanServer().registerMBean((Object)adapter, new ObjectName("JMX:name=htmlAdaptorServer"));
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
        if (jmxrmiPort >= 0) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            Registry registry = LocateRegistry.createRegistry(jmxrmiPort);
            registry.list();
            HashMap<String, String[]> env = new HashMap<String, String[]>();
            if (user != null && user.length() > 0) {
                String[] creds = new String[]{user, new String(password)};
                env.put("jmx.remote.credentials", creds);
            }
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + jmxrmiPort + "/server");
            JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
            cs.start();
            mbs.registerMBean(cs, new ObjectName("connector:type=standard_rmi"));
        }
    }

    public static void registerMBean(Object mbean, String name) {
        try {
            JMXService.register(mbean, new ObjectName(name));
        }
        catch (Exception ex) {
            logger.info("Cannot register {} as MBean", (Object)name, (Object)ex);
        }
    }

    public static ObjectInstance registerIfAbsent(String name, Supplier supplier) throws JMException {
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(name);
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalArgumentException(ex);
        }
        Optional<ObjectInstance> optional = JMXService.find(objectName);
        if (!optional.isPresent()) {
            try {
                JMXService.register(supplier.get(), objectName);
                return JMXService.find(objectName).orElseThrow(() -> new InstanceNotFoundException("ObjectInstance with name=" + name + " not found."));
            }
            catch (InstanceAlreadyExistsException ex) {
                return JMXService.find(objectName).orElseThrow(() -> ex);
            }
        }
        return optional.get();
    }

    private static void register(Object mbean, ObjectName objectName) throws JMException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        JmxServer jmxServer = new JmxServer(server);
        if (mbean.getClass().getAnnotation(JmxResource.class) != null) {
            jmxServer.register(mbean, objectName, null, null, null);
        } else {
            Class<?>[] interfaces;
            boolean conformToMBean = false;
            for (Class<?> intf : interfaces = mbean.getClass().getInterfaces()) {
                MXBean annotation = intf.getAnnotation(MXBean.class);
                if (annotation != null) {
                    conformToMBean = annotation.value();
                    break;
                }
                if (!intf.getSimpleName().endsWith("MXBean") && !intf.getSimpleName().endsWith("MBean")) continue;
                conformToMBean = true;
                break;
            }
            if (conformToMBean) {
                server.registerMBean(mbean, objectName);
            } else {
                jmxServer.register(mbean, objectName, null, null, null);
            }
        }
    }

    public static void unregisterMBean(String name) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            JmxServer jmxServer = new JmxServer(server);
            jmxServer.unregister(new ObjectName(name));
        }
        catch (Exception e) {
            logger.warn("Cannot register " + name + " as MBean", (Throwable)e);
        }
    }

    public static Optional<ObjectInstance> find(String objectName) {
        try {
            return JMXService.find(new ObjectName(objectName));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Optional<ObjectInstance> find(ObjectName objectName) {
        ObjectInstance instance;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            instance = mBeanServer.getObjectInstance(objectName);
        }
        catch (InstanceNotFoundException e) {
            Logger.suppress((Throwable)e);
            return Optional.empty();
        }
        return Optional.of(instance);
    }

    public static Set<ObjectInstance> query(ObjectName objectName) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        return mBeanServer.queryMBeans(objectName, null);
    }

    public static Object invoke(ObjectName objectName, String method, Object[] arguments, String[] signature) throws MBeanException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            return mBeanServer.invoke(objectName, method, arguments, signature);
        }
        catch (InstanceNotFoundException | ReflectionException e) {
            throw new MBeanException(e);
        }
    }

    public static Object invoke(ObjectName objectName, String methodName, Object ... arguments) throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectInstance> instances = mBeanServer.queryMBeans(objectName, null);
        if (instances.isEmpty()) {
            return null;
        }
        if (instances.size() > 1) {
            throw new IllegalStateException("More than one instances found with the objectName");
        }
        ObjectInstance instance = instances.iterator().next();
        MBeanInfo info = mBeanServer.getMBeanInfo(instance.getObjectName());
        Object ret = null;
        boolean found = false;
        int arglen = 0;
        if (arguments != null) {
            arglen = arguments.length;
        }
        for (MBeanOperationInfo op : info.getOperations()) {
            if (!op.getName().equals(methodName)) continue;
            String[] signature = new String[]{};
            Object[] args = new Object[]{};
            MBeanParameterInfo[] params = op.getSignature();
            if (arglen != params.length) continue;
            if (arguments != null) {
                signature = new String[params.length];
                args = new Object[params.length];
                for (int i = 0; i < params.length; ++i) {
                    MBeanParameterInfo entry = params[i];
                    signature[i] = entry.getType();
                    Class toType = ObjectConverter.loadClass((ClassLoader)mBeanServer.getClassLoaderFor(instance.getObjectName()), (String)entry.getType());
                    args[i] = new ObjectConverter().convert(arguments[i], (Type)toType, null);
                }
            }
            ret = mBeanServer.invoke(instance.getObjectName(), methodName, args, signature);
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException("No method named \"" + methodName + "\" with " + arglen + " parameters.");
        }
        return ret;
    }
}

