/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.jmx;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;

public class Converter {
    private Converter() {
    }

    public static List convert(TabularData table) {
        ArrayList<Map<Object, Object>> rows = new ArrayList<Map<Object, Object>>();
        Set<?> keys = table.keySet();
        for (List key : keys) {
            Map<String, Object> row = Converter.convert(table.get(key.toArray()));
            if (row == null) continue;
            if (row.size() == 2 && row.containsKey("key") && row.get("value") instanceof Map) {
                LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                m.put("key", row.get("key"));
                m.putAll((Map)row.get("value"));
                rows.add(m);
                continue;
            }
            rows.add(row);
        }
        return rows;
    }

    public static Map<String, Object> convert(CompositeData composite) {
        if (composite == null) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        CompositeType type = composite.getCompositeType();
        Set<String> keys = type.keySet();
        for (String key : keys) {
            Object value = composite.get(key);
            if (value == null) continue;
            map.put(key, Converter.convert(value));
        }
        return map;
    }

    public static Object convert(Object obj) {
        if (obj == null) {
            return null;
        }
        Object[] object = obj;
        if (object.getClass().isArray()) {
            LinkedList<Object> list = new LinkedList<Object>();
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(object, i);
                list.add(Converter.convert(item));
            }
            object = list.toArray();
        } else {
            if (object instanceof TabularData) {
                return Converter.convert((TabularData)object);
            }
            if (object instanceof CompositeData) {
                return Converter.convert((CompositeData)object);
            }
        }
        return object;
    }
}

