/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.jmx.stat;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import net.e6tech.elements.common.util.datastructure.BinarySearchList;
import net.e6tech.elements.jmx.stat.DataPoint;
import net.e6tech.elements.jmx.stat.MeasurementMXBean;

public class Measurement
implements Serializable,
MeasurementMXBean {
    private static final long serialVersionUID = -5888966219198957050L;
    private String name;
    private String unit;
    private long count = 0L;
    private long total = 0L;
    private double average = 0.0;
    private double median = 0.0;
    private double sum = 0.0;
    private double sum_x_2 = 0.0;
    private double stdDev = 0.0;
    private long windowWidth = 300000L;
    private int windowMaxCount = Integer.MAX_VALUE;
    private boolean dirty = false;
    private boolean enabled = true;
    protected transient LinkedList<DataPoint> sortedByTime = new LinkedList();
    protected transient LinkedList<Long> failures = new LinkedList();
    protected transient BinarySearchList<DataPoint> sortedByValue = new BinarySearchList();

    public Measurement() {
    }

    public Measurement(boolean enabled) {
        this.enabled = enabled;
    }

    public Measurement(String name, String unit, boolean enabled) {
        this.name = name;
        this.unit = unit;
        this.enabled = enabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    @Override
    public long getCount() {
        this.recalculate();
        return this.count;
    }

    @Override
    public double getAverage() {
        this.recalculate();
        return this.average;
    }

    @Override
    public double getMedian() {
        this.recalculate();
        return this.median;
    }

    @Override
    public double getSum() {
        this.recalculate();
        return this.sum;
    }

    @Override
    public double getStdDev() {
        this.recalculate();
        return this.stdDev;
    }

    @Override
    public long getWindowWidth() {
        return this.windowWidth;
    }

    public void setWindowWidth(long windowWidth) {
        this.windowWidth = windowWidth;
    }

    public int getWindowMaxCount() {
        return this.windowMaxCount;
    }

    public void setWindowMaxCount(int windowMaxCount) {
        this.windowMaxCount = windowMaxCount;
    }

    @Override
    public long getFailureCount() {
        this.recalculate();
        return this.failures.size();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public synchronized void fail() {
        if (!this.isEnabled()) {
            return;
        }
        this.failures.add(System.currentTimeMillis());
        this.dirty = true;
        this.trimFailures();
    }

    @Override
    public synchronized void add(double value) {
        this.add(new DataPoint(System.currentTimeMillis(), value));
    }

    public Measurement append(double value) {
        this.add(value);
        return this;
    }

    synchronized void recalculate() {
        if (!this.dirty && !this.sortedByTime.isEmpty() && this.sortedByTime.getFirst().getTimestamp() >= System.currentTimeMillis() - this.windowWidth) {
            return;
        }
        this.trimFailures();
        this.trimData();
        this.count = this.sortedByTime.size();
        if (this.count == 0L) {
            this.average = 0.0;
            this.median = 0.0;
        } else {
            this.average = this.sum / (double)this.count;
            int index = (int)this.count / 2;
            if (this.count == (long)(2 * index)) {
                DataPoint dp1 = (DataPoint)this.sortedByValue.get(index);
                DataPoint dp2 = (DataPoint)this.sortedByValue.get(index - 1);
                this.median = (dp1.getValue() + dp2.getValue()) / 2.0;
            } else {
                this.median = ((DataPoint)this.sortedByValue.get(index)).getValue();
            }
        }
        if (this.count > 1L) {
            double n_ave_2 = (double)this.count * this.average * this.average;
            double var = (this.sum_x_2 - n_ave_2) / (double)(this.count - 1L);
            this.stdDev = Math.sqrt(var);
        } else {
            this.stdDev = 0.0;
        }
        this.dirty = false;
    }

    private synchronized void add(DataPoint dp) {
        if (!this.isEnabled()) {
            return;
        }
        ++this.total;
        this.sortedByTime.add(dp);
        this.sortedByValue.add((Comparable)dp);
        double value = dp.getValue();
        this.sum += value;
        this.sum_x_2 += value * value;
        this.dirty = true;
        this.trimData();
    }

    private synchronized void trimData() {
        long expire = System.currentTimeMillis() - this.windowWidth;
        while (!this.sortedByTime.isEmpty() && this.sortedByTime.getFirst().getTimestamp() < expire) {
            this.remove();
        }
        while (this.sortedByTime.size() > this.windowMaxCount) {
            this.remove();
        }
    }

    private synchronized void trimFailures() {
        long expire = System.currentTimeMillis() - this.windowWidth;
        while (!this.failures.isEmpty() && this.failures.getFirst() < expire) {
            this.failures.remove();
        }
        while (this.failures.size() > this.windowMaxCount) {
            this.failures.remove();
        }
    }

    DataPoint remove() {
        if (!this.sortedByTime.isEmpty()) {
            DataPoint dp = this.sortedByTime.removeFirst();
            this.sortedByValue.removeFirst((Comparable)dp);
            double removed = dp.getValue();
            this.sum -= removed;
            this.sum_x_2 -= removed * removed;
            this.dirty = true;
            return dp;
        }
        return null;
    }

    public String dump() {
        StringBuilder builder = new StringBuilder();
        builder.append("count=" + this.sortedByValue.size() + " ");
        boolean first = true;
        for (DataPoint dp : this.sortedByTime) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append('[').append(dp.getTimestamp()).append(",").append(dp.getValue()).append(']');
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.recalculate();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd kk:mm:ss.SSS");
        StringBuilder builder = new StringBuilder();
        builder.append("count=" + this.count + ", ");
        builder.append("average=" + this.average + ", ");
        builder.append("median=" + this.median + ", ");
        builder.append("stddev=" + this.stdDev + ", ");
        builder.append("failureCount=" + this.failures.size() + ", ");
        DataPoint first = null;
        DataPoint last = null;
        Measurement measurement = this;
        synchronized (measurement) {
            if (!this.sortedByTime.isEmpty()) {
                first = this.sortedByTime.getFirst();
                last = this.sortedByTime.getLast();
            }
        }
        if (first != null) {
            builder.append("windowWidth=" + this.windowWidth + ", ");
            builder.append("first=" + dateFormat.format(new Date(first.getTimestamp())) + ", ");
            builder.append("last=" + dateFormat.format(new Date(last.getTimestamp())) + " ");
        } else {
            builder.append("windowWidth=" + this.windowWidth + " ");
        }
        return builder.toString();
    }
}

