/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.jmx.stat;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import net.e6tech.elements.common.logging.LogLevel;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.jmx.stat.Measurement;

public class Gauge
implements Initializable {
    private static final Timer TIMER = new Timer();
    private static final Logger defaultLogger = Logger.getLogger();
    private long period = 300000L;
    private int cacheInitialCapacity = 20;
    private int cacheMaxSize = 2000;
    private Cache<String, Measurement> measurements;
    private Logger logger = defaultLogger;
    private LogLevel logLevel = LogLevel.INFO;
    private long windowWidth = 300000L;
    private int maxCount = 1000;
    private boolean enabled = true;
    private BiFunction<String, Measurement, String> format = (key, measurement) -> String.format("key=%s: %s", key, measurement);
    private volatile boolean scheduled = false;
    private long lastRun = 0L;
    private TimerTask task;

    public synchronized void initialize(Resources resources) {
        this.initCache();
    }

    private synchronized void initCache() {
        this.measurements = CacheBuilder.newBuilder().concurrencyLevel(Provision.cacheBuilderConcurrencyLevel.intValue()).initialCapacity(this.cacheInitialCapacity).maximumSize((long)this.cacheMaxSize).expireAfterAccess(2L * this.period + 10000L, TimeUnit.MILLISECONDS).build();
    }

    private synchronized void schedule() {
        if (!this.scheduled) {
            this.task = new GaugeTask();
            if (this.lastRun + this.period <= System.currentTimeMillis()) {
                this.lastRun = System.currentTimeMillis();
            }
            this.lastRun += this.period;
            long delay = this.lastRun - System.currentTimeMillis();
            if (delay < 0L) {
                delay = 0L;
            }
            TIMER.schedule(this.task, delay);
            this.scheduled = true;
        }
    }

    public void cancel() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    public void print() {
        for (Map.Entry entry : this.measurements.asMap().entrySet()) {
            this.logger.log(this.logLevel, this.format.apply((String)entry.getKey(), (Measurement)entry.getValue()), null);
        }
    }

    public int getCacheInitialCapacity() {
        return this.cacheInitialCapacity;
    }

    public void setCacheInitialCapacity(int cacheInitialCapacity) {
        this.cacheInitialCapacity = cacheInitialCapacity;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public Cache<String, Measurement> getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(Cache<String, Measurement> measurements) {
        this.measurements = measurements;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public long getWindowWidth() {
        return this.windowWidth;
    }

    public void setWindowWidth(long windowWidth) {
        this.windowWidth = windowWidth;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public BiFunction<String, Measurement, String> getFormat() {
        return this.format;
    }

    public void setFormat(BiFunction<String, Measurement, String> format) {
        this.format = format;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public void add(String label, long duration) {
        Measurement measurement = this.getMeasurement(label);
        if (measurement != null) {
            measurement.add(duration);
        }
        this.schedule();
    }

    public synchronized Measurement getMeasurement(String key) {
        try {
            if (this.measurements == null) {
                this.initCache();
            }
            return (Measurement)this.measurements.get((Object)key, () -> {
                Measurement m = new Measurement();
                m.setEnabled(this.enabled);
                m.setWindowWidth(this.windowWidth);
                m.setWindowMaxCount(this.maxCount);
                return m;
            });
        }
        catch (ExecutionException e) {
            return (Measurement)this.measurements.getIfPresent((Object)key);
        }
    }

    class GaugeTask
    extends TimerTask {
        GaugeTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConcurrentMap map = Gauge.this.measurements.asMap();
            map.values().removeIf(val -> val.getCount() <= 0L);
            Gauge.this.print();
            Gauge gauge = Gauge.this;
            synchronized (gauge) {
                Gauge.this.scheduled = false;
                if (!map.isEmpty()) {
                    Gauge.this.schedule();
                }
            }
        }
    }
}

