/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.jmx;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.SystemException;

public class JMXHtmlServer
extends HtmlAdaptorServer {
    private static final String INTERRUPT_SYS_CALL_MSG = "Interrupted system call";
    private Logger myLogger = Logger.getLogger();
    private InetAddress bindAddress;

    public JMXHtmlServer() {
    }

    public JMXHtmlServer(int port) {
        super(port);
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    protected void doBind() throws InterruptedException {
        int port = this.getPort();
        int maxActiveClientCount = this.getMaxActiveClientCount();
        this.myLogger.info("doBind: Bind the socket listener to [Port={}, MaxActiveClientCount={}]", (Object)port, (Object)maxActiveClientCount);
        try {
            ServerSocket serverSocket = new ServerSocket(port, 2 * maxActiveClientCount, this.getBindAddress());
            Field field = HtmlAdaptorServer.class.getDeclaredField("sockListen");
            field.setAccessible(true);
            field.set((Object)this, serverSocket);
            this.myLogger.info("doBind: Bound to [Address={}, Port={}]", (Object)serverSocket.getInetAddress(), (Object)serverSocket.getLocalPort());
        }
        catch (SocketException e) {
            if (e.getMessage().equals(INTERRUPT_SYS_CALL_MSG)) {
                throw new InterruptedException(e.toString());
            }
            throw new CommunicationException((Throwable)e);
        }
        catch (InterruptedIOException e) {
            Logger.suppress((Throwable)e);
            throw new InterruptedException(e.toString());
        }
        catch (IOException e) {
            throw new CommunicationException((Throwable)e);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new SystemException((Throwable)e);
        }
    }
}

