/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.jmx.stat;

import java.io.Serializable;
import java.util.LinkedList;
import net.e6tech.elements.common.util.datastructure.BinarySearchList;
import net.e6tech.elements.jmx.stat.DataPoint;
import net.e6tech.elements.jmx.stat.MeasurementMXBean;

public class Measurement
implements Serializable,
MeasurementMXBean {
    private static final long serialVersionUID = -5888966219198957050L;
    private String name;
    private String unit;
    private long count = 0L;
    private long total = 0L;
    private double average = 0.0;
    private double median = 0.0;
    private double sum = 0.0;
    private double sum_x_2 = 0.0;
    private double stdDev = 0.0;
    private long windowSize = 300000L;
    private long lastUpdate = 0L;
    private long firstUpdate = 0L;
    private boolean dirty = false;
    private boolean enabled = true;
    protected transient LinkedList<DataPoint> sortedByTime = new LinkedList();
    protected transient LinkedList<Long> failures = new LinkedList();
    protected transient BinarySearchList sortedByValue = new BinarySearchList();

    public Measurement() {
    }

    public Measurement(boolean enabled) {
        this.enabled = enabled;
    }

    public Measurement(String name, String unit, boolean enabled) {
        this.name = name;
        this.unit = unit;
        this.enabled = enabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    @Override
    public long getCount() {
        if (this.dirty) {
            this.recalculate();
        }
        return this.count;
    }

    @Override
    public double getAverage() {
        if (this.dirty) {
            this.recalculate();
        }
        return this.average;
    }

    @Override
    public double getMedian() {
        if (this.dirty) {
            this.recalculate();
        }
        return this.median;
    }

    @Override
    public double getSum() {
        if (this.dirty) {
            this.recalculate();
        }
        return this.sum;
    }

    @Override
    public double getStdDev() {
        if (this.dirty) {
            this.recalculate();
        }
        return this.stdDev;
    }

    @Override
    public long getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(long windowSize) {
        this.windowSize = windowSize;
    }

    @Override
    public long getFailureCount() {
        if (this.dirty) {
            this.recalculate();
        }
        return this.failures.size();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public synchronized void fail() {
        if (!this.isEnabled()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (this.firstUpdate == 0L) {
            this.firstUpdate = System.currentTimeMillis();
        }
        this.failures.add(now);
        this.dirty = true;
        if (System.currentTimeMillis() - this.firstUpdate > this.windowSize) {
            this.recalculate();
        }
    }

    @Override
    public synchronized void add(double value) {
        if (!this.isEnabled()) {
            return;
        }
        ++this.total;
        long now = System.currentTimeMillis();
        if (this.firstUpdate == 0L) {
            this.firstUpdate = System.currentTimeMillis();
        }
        this.add(new DataPoint(now, value));
    }

    public Measurement append(double value) {
        if (!this.isEnabled()) {
            return this;
        }
        this.add(value);
        return this;
    }

    protected synchronized void recalculate() {
        this.lastUpdate = System.currentTimeMillis();
        long expire = this.lastUpdate - this.windowSize;
        while (this.failures.size() > 0 && this.failures.getFirst() < expire) {
            this.failures.remove();
        }
        long firstFailure = 0L;
        if (this.failures.size() > 0) {
            firstFailure = this.failures.getFirst();
        }
        if (this.sortedByTime.size() == 0) {
            this.firstUpdate = firstFailure;
            return;
        }
        while (this.sortedByTime.size() > 0 && this.sortedByTime.getFirst().getTimestamp() < expire) {
            this.remove();
        }
        this.count = this.sortedByTime.size();
        if (this.count == 0L) {
            this.average = 0.0;
            this.median = 0.0;
        } else {
            this.average = this.sum / (double)this.count;
            int index = (int)this.count / 2;
            if (this.count == (long)(2 * index)) {
                DataPoint dp1 = (DataPoint)this.sortedByValue.get(index);
                DataPoint dp2 = (DataPoint)this.sortedByValue.get(index - 1);
                this.median = (dp1.getValue() + dp2.getValue()) / 2.0;
            } else {
                this.median = ((DataPoint)this.sortedByValue.get(index)).getValue();
            }
        }
        if (this.count > 1L) {
            double n_ave_2 = (double)this.count * this.average * this.average;
            double var = (this.sum_x_2 - n_ave_2) / (double)(this.count - 1L);
            this.stdDev = Math.sqrt(var);
        } else {
            this.stdDev = 0.0;
        }
        long firstDataUpdate = 0L;
        if (this.sortedByTime.size() > 0) {
            firstDataUpdate = this.sortedByTime.getFirst().getTimestamp();
        }
        this.firstUpdate = 0L;
        if (firstFailure > 0L) {
            this.firstUpdate = firstFailure;
        }
        if (firstDataUpdate > 0L) {
            this.firstUpdate = Math.min(this.firstUpdate, firstDataUpdate);
        }
        this.dirty = false;
    }

    protected void add(DataPoint dp) {
        if (!this.isEnabled()) {
            return;
        }
        this.sortedByTime.add(dp);
        this.sortedByValue.add((Comparable)dp);
        double value = dp.getValue();
        this.sum += value;
        this.sum_x_2 += value * value;
        this.dirty = true;
        if (System.currentTimeMillis() - this.firstUpdate > this.windowSize) {
            this.recalculate();
        }
    }

    protected DataPoint remove() {
        if (this.sortedByTime.size() > 0) {
            DataPoint dp = this.sortedByTime.removeFirst();
            this.sortedByValue.remove((Comparable)dp);
            double removed = dp.getValue();
            this.sum -= removed;
            this.sum_x_2 -= removed * removed;
            this.dirty = true;
            return dp;
        }
        return null;
    }

    public String toString() {
        if (this.dirty) {
            this.recalculate();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("count=" + this.count + " ");
        builder.append("average=" + this.average + " ");
        builder.append("stddev=" + this.stdDev + " ");
        builder.append("failureCount=" + this.failures.size() + " ");
        builder.append("windowSize=" + this.windowSize + " ");
        return builder.toString();
    }
}

