/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.inject.Injector;
import net.e6tech.elements.common.inject.Module;
import net.e6tech.elements.common.logging.LogLevel;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.resources.AfterAbort;
import net.e6tech.elements.common.resources.AfterCommit;
import net.e6tech.elements.common.resources.BindClass;
import net.e6tech.elements.common.resources.Binding;
import net.e6tech.elements.common.resources.Bindings;
import net.e6tech.elements.common.resources.Configurator;
import net.e6tech.elements.common.resources.Injectable;
import net.e6tech.elements.common.resources.InstanceNotFoundException;
import net.e6tech.elements.common.resources.OnAbort;
import net.e6tech.elements.common.resources.OnClosed;
import net.e6tech.elements.common.resources.OnCommit;
import net.e6tech.elements.common.resources.OnOpen;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.ResourcePool;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.ResourcesState;
import net.e6tech.elements.common.resources.Retry;
import net.e6tech.elements.common.resources.plugin.Plugin;
import net.e6tech.elements.common.resources.plugin.PluginManager;
import net.e6tech.elements.common.resources.plugin.PluginPath;
import net.e6tech.elements.common.resources.plugin.PluginPaths;
import net.e6tech.elements.common.util.ExceptionMapper;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.function.ConsumerWithException;
import net.e6tech.elements.common.util.function.FunctionWithException;

@BindClass(value={Resources.class})
public class Resources
implements AutoCloseable,
ResourcePool {
    private static ThreadLocal<Deque<Resources>> activeResources = new ThreadLocal();
    private static Logger logger = Logger.getLogger(Resources.class);
    private static final String ABORT_DUE_TO_EXCEPTION = "Aborting due to exception";
    private ResourceManager resourceManager;
    private Retry retry;
    protected ResourcesState state;
    protected Configurator configurator = new Configurator();
    private Configurator initialConfigurator;
    private Consumer<? extends Resources> preOpen;
    private List<Replay<? extends Resources, ?, ? extends Exception>> replays = new LinkedList();
    private Object lastResult;
    private Throwable lastException;
    private boolean submitting = false;
    private Boolean replayable;

    public static Resources parent(Resources current) {
        Deque<Resources> deque = activeResources.get();
        if (deque == null) {
            return null;
        }
        Iterator<Resources> iterator = deque.iterator();
        while (iterator.hasNext()) {
            Resources r = iterator.next();
            if (r != current) continue;
            return iterator.hasNext() ? iterator.next() : null;
        }
        return null;
    }

    public static Iterator<Resources> parents(Resources current) {
        Deque<Resources> deque = activeResources.get();
        if (deque == null) {
            return null;
        }
        Iterator<Resources> iterator = deque.iterator();
        while (iterator.hasNext()) {
            Resources r = iterator.next();
            if (r != current) continue;
            return iterator;
        }
        return Collections.emptyIterator();
    }

    protected Resources(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.state = new ResourcesState(this);
        this.getModule().bindInstance(this.getClass(), this);
    }

    public <T> T nullableVar(String key) {
        Optional<Object> optional = this.state.getVariable(key);
        return (T)optional.orElseGet(() -> this.resourceManager.nullableVar(key));
    }

    public <T> Optional<T> getVariable(String key) {
        Optional optional = this.state.getVariable(key);
        if (optional.isPresent()) {
            return optional;
        }
        return this.resourceManager.getVariable(key);
    }

    public Resources setVariable(String key, Object val) {
        this.state.setVariable(key, val);
        return this;
    }

    public <T> Map<String, T> getMapVariable(Class<T> key) {
        return this.state.computeMapIfAbsent(key);
    }

    public <T> T getMapVariable(Class<T> key, String name) {
        return this.state.computeMapIfAbsent(key).get(name);
    }

    public Retry getRetry() {
        return this.retry;
    }

    @Inject(optional=true)
    public void setRetry(Retry retry) {
        this.retry = retry;
    }

    void setPreOpen(Consumer<? extends Resources> preOpen) {
        this.preOpen = preOpen;
    }

    public synchronized boolean isCommitted() {
        return this.state.getState() == ResourcesState.State.COMMITTED;
    }

    public synchronized boolean isOpen() {
        return this.state.getState() == ResourcesState.State.OPEN;
    }

    public synchronized boolean isAborted() {
        return this.state.getState() == ResourcesState.State.ABORTED;
    }

    public synchronized boolean isClosed() {
        return !this.isOpen();
    }

    public synchronized boolean isDiscarded() {
        return this.resourceManager == null;
    }

    public Injector getParentInjector() {
        return this.state.getParentInjector();
    }

    public void setParentInjector(Injector injector) {
        this.state.setParentInjector(injector);
    }

    List<ResourceProvider> getExternalResourceProviders() {
        return this.state.getExternalResourceProviders();
    }

    void setExternalResourceProviders(List<ResourceProvider> externalResourceProviders) {
        this.state.setExternalResourceProviders(externalResourceProviders);
    }

    private List<ResourceProvider> getResourceProviders() {
        return this.state.getResourceProviders();
    }

    public synchronized Resources addResourceProvider(ResourceProvider resourceProvider) {
        this.getResourceProviders().add(resourceProvider);
        if (this.isOpen()) {
            resourceProvider.onOpen(this);
        }
        if (this.isCommitted()) {
            resourceProvider.onCommit(this);
        }
        if (this.isCommitted()) {
            resourceProvider.afterCommit(this);
        }
        if (this.isAborted()) {
            resourceProvider.onAbort(this);
        }
        return this;
    }

    public Boolean getReplayable() {
        return this.replayable;
    }

    public void setReplayable(Boolean replayable) {
        this.replayable = replayable;
    }

    public synchronized Resources onCommit(OnCommit onCommit) {
        this.addResourceProvider(onCommit);
        return this;
    }

    public synchronized Resources onCommit(Runnable runnable) {
        OnCommit on = res -> runnable.run();
        this.onCommit(on);
        return this;
    }

    public synchronized Resources afterCommit(AfterCommit afterCommit) {
        this.addResourceProvider(afterCommit);
        return this;
    }

    public synchronized Resources afterCommit(Runnable runnable) {
        AfterCommit after = res -> runnable.run();
        this.afterCommit(after);
        return this;
    }

    public synchronized Resources onCommitOrAbort(Runnable runnable) {
        this.onCommit(runnable);
        this.onAbort(runnable);
        return this;
    }

    public synchronized Resources onOpen(OnOpen onOpen) {
        this.addResourceProvider(onOpen);
        return this;
    }

    public synchronized Resources onOpen(Runnable runnable) {
        OnOpen on = res -> runnable.run();
        this.onOpen(on);
        return this;
    }

    public synchronized Resources onAbort(OnAbort onAbort) {
        this.addResourceProvider(onAbort);
        return this;
    }

    public synchronized Resources onAbort(Runnable runnable) {
        OnAbort on = res -> runnable.run();
        this.onAbort(on);
        return this;
    }

    public synchronized Resources afterAbort(AfterAbort afterAbort) {
        this.addResourceProvider(afterAbort);
        return this;
    }

    public synchronized Resources afterAbort(Runnable runnable) {
        AfterAbort after = res -> runnable.run();
        this.afterAbort(after);
        return this;
    }

    public synchronized Resources afterCommitOrAbort(Runnable runnable) {
        this.afterCommit(runnable);
        this.afterAbort(runnable);
        return this;
    }

    public synchronized Resources onClosed(OnClosed onClosed) {
        this.addResourceProvider(onClosed);
        return this;
    }

    public synchronized Resources onClosed(Runnable runnable) {
        OnClosed on = res -> runnable.run();
        this.onClosed(on);
        return this;
    }

    public synchronized boolean remove(ResourceProvider provider) {
        return this.getResourceProviders().remove(provider);
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public PluginManager getPluginManager() {
        return this.getResourceManager().getPluginManager().from(this);
    }

    public <S, T extends Plugin> Optional<T> getPlugin(Class<S> c1, String n1, Class<T> c2, Object ... args) {
        return this.getPlugin(PluginPath.of(c1, n1).and(c2), args);
    }

    public <R, S, T extends Plugin> Optional<T> getPlugin(Class<R> c1, String n1, Class<S> c2, String n2, Class<T> c3, Object ... args) {
        return this.getPlugin(PluginPath.of(c1, n1).and(c2, n2).and(c3), args);
    }

    public <T extends Plugin> Optional<T> getPlugin(PluginPath<T> path, Object ... args) {
        PluginManager plugin = this.getInstance(PluginManager.class);
        return plugin.from(this).get(path, args);
    }

    public <T extends Plugin> Optional<T> getPlugin(PluginPaths<T> paths, Object ... args) {
        PluginManager plugin = this.getInstance(PluginManager.class);
        return plugin.from(this).get(paths, args);
    }

    public Module getModule() {
        return this.state.getModule();
    }

    public Resources addModule(Module module) {
        this.state.addModule(module);
        return this;
    }

    <T> Binding<T> getBinding(Class<T> cls) {
        return new Binding<T>(this, cls);
    }

    public <E extends Exception> void briefly(ConsumerWithException<Bindings, E> consumer) throws E {
        Bindings bindings = new Bindings(this);
        try {
            consumer.accept(bindings);
        }
        finally {
            bindings.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Exception> T briefly(FunctionWithException<Bindings, T, E> function) throws E {
        Bindings bindings = new Bindings(this);
        try {
            T t = function.apply(bindings);
            return t;
        }
        finally {
            bindings.restore();
        }
    }

    public <T> T tryBind(Class<T> cls, Callable<T> callable) {
        return this.state.tryBind(cls, callable);
    }

    public <T> boolean isBound(Class<T> cls) {
        return this.getModule().getBoundInstance(cls) != null;
    }

    @Override
    public <T> T bind(Class<T> cls, T resource) {
        return this.state.bind(cls, resource);
    }

    @Override
    public <T> T rebind(Class<T> cls, T resource) {
        return this.state.rebind(cls, resource);
    }

    @Override
    public <T> T unbind(Class<T> cls) {
        return this.state.unbind(cls);
    }

    @Override
    public void bindClass(Class cls, Class service) {
        this.state.bindClass(cls, service);
    }

    @Override
    public <T> T bindNamedInstance(Class<T> cls, String name, T resource) {
        return this.state.bindNamedInstance(cls, name, resource);
    }

    @Override
    public <T> T rebindNamedInstance(Class<T> cls, String name, T resource) {
        return this.state.rebindNamedInstance(cls, name, resource);
    }

    public <T> T getNamedInstance(Class<T> cls, String name) {
        return this.state.getNamedInstance(this, cls, name);
    }

    @Override
    public <T> T inject(T object) {
        return this.inject(object, true);
    }

    public <T> T inject(T object, boolean strict) {
        return this.inject(object, strict, new HashSet<Integer>());
    }

    private <T> T inject(T object, boolean strict, Set<Integer> seen) {
        if (object == null) {
            return null;
        }
        if (seen.contains(System.identityHashCode(object))) {
            return object;
        }
        T injected = this.state.inject(this, object, strict);
        seen.add(System.identityHashCode(object));
        ResourceManager.ClassInjectionInfo info = this.resourceManager.getInjections().get(object.getClass());
        if (info == null) {
            info = new ResourceManager.ClassInjectionInfo();
            Class<?> cls = object.getClass();
            Package p = cls.getPackage();
            if (p == null || !p.getName().startsWith("java.") && !p.getName().startsWith("javax.")) {
                while (cls != null && !cls.equals(Object.class)) {
                    for (Field f : cls.getDeclaredFields()) {
                        if (f.getAnnotation(Injectable.class) == null && f.getType().getAnnotation(Injectable.class) == null) continue;
                        f.setAccessible(true);
                        info.addInjectableField(f);
                    }
                    cls = cls.getSuperclass();
                }
                BeanInfo beanInfo = Reflection.getBeanInfo(object.getClass());
                for (PropertyDescriptor prop : beanInfo.getPropertyDescriptors()) {
                    boolean hasAnnotation;
                    if (prop.getReadMethod() == null) continue;
                    boolean bl = hasAnnotation = prop.getPropertyType().getAnnotation(Injectable.class) != null;
                    if (!hasAnnotation) {
                        boolean bl2 = hasAnnotation = prop.getReadMethod() != null && prop.getReadMethod().getAnnotation(Injectable.class) != null;
                    }
                    if (!hasAnnotation) {
                        boolean bl3 = hasAnnotation = prop.getWriteMethod() != null && prop.getWriteMethod().getAnnotation(Injectable.class) != null;
                    }
                    if (!hasAnnotation) continue;
                    info.addInjectableProperty(prop);
                }
            }
            this.resourceManager.getInjections().put(object.getClass(), info);
        }
        for (Field f : info.getInjectableFields()) {
            try {
                Object injectField = f.get(object);
                if (injectField == null) continue;
                this.inject(injectField, strict, seen);
            }
            catch (IllegalAccessException e) {
                throw new SystemException(e);
            }
        }
        for (PropertyDescriptor d : info.getInjectableProperties()) {
            try {
                Object injectProp = d.getReadMethod().invoke(object, new Object[0]);
                if (injectProp == null) continue;
                this.inject(injectProp, strict, seen);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SystemException(e);
            }
        }
        return injected;
    }

    public boolean hasInstance(Class cls) {
        return this.state.hasInstance(this, cls);
    }

    public <T> T getInstance(Class<T> cls) {
        return this.state.getInstance(this, cls);
    }

    public <T> T getInstance(Class<T> cls, Supplier<T> call) {
        try {
            return this.state.getInstance(this, cls);
        }
        catch (InstanceNotFoundException ex) {
            Logger.suppress(ex);
            return call.get();
        }
    }

    public Configurator configurator() {
        return this.configurator;
    }

    public Resources configure(Configurator configurator) {
        this.configurator.putAll(configurator);
        if (this.initialConfigurator == null) {
            this.initialConfigurator = new Configurator();
        }
        this.initialConfigurator.putAll(configurator);
        return this;
    }

    public synchronized Resources onOpen() {
        if (!this.isOpen()) {
            this.state.setState(ResourcesState.State.OPEN);
            try {
                List<ResourceProvider> list;
                List<ResourceProvider> originalList = list = this.state.getResourceProviders();
                while (!list.isEmpty()) {
                    ArrayList<ResourceProvider> additionalResourceProviders = new ArrayList<ResourceProvider>();
                    this.state.setResourceProviders(additionalResourceProviders);
                    for (ResourceProvider resourceProvider : list) {
                        resourceProvider.onOpen(this);
                    }
                    originalList.addAll(additionalResourceProviders);
                    list = additionalResourceProviders;
                }
                this.state.setResourceProviders(originalList);
                this.state.onOpen(this);
                for (ResourceProvider p : this.getExternalResourceProviders()) {
                    p.afterOpen(this);
                }
                for (ResourceProvider resourceProvider : this.state.getResourceProviders()) {
                    resourceProvider.afterOpen(this);
                }
            }
            catch (Exception ex) {
                this.abort();
                throw ex;
            }
        }
        return this;
    }

    protected <T extends Resources, R, E extends Exception> R replay(Throwable th, Replay<T, R, E> replay) {
        if (this.isAborted() || this.retry == null) {
            this.log(LogLevel.WARN, ABORT_DUE_TO_EXCEPTION, th);
            if (!this.isAborted()) {
                this.abort();
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new SystemException(th);
        }
        try {
            return (R)this.retry.retry(th, () -> {
                StringBuilder builder = new StringBuilder();
                builder.append("Resources retrying due to error: ").append(ExceptionMapper.unwrap(th).getClass()).append(", message: ").append(th.getMessage());
                Reflection.printStackTrace(builder, "    ", 2, 8);
                this.log(LogLevel.WARN, builder.toString(), null);
                List<Replay<Resources, ?, Exception>> savedReplays = this.replays;
                this.replays = Collections.emptyList();
                try {
                    this.abort();
                }
                catch (Exception th2) {
                    Logger.suppress(th2);
                }
                this.replays = savedReplays;
                Resources retryResources = this.resourceManager.open(this.initialConfigurator, this.preOpen);
                retryResources.state.parentInjector = this.state.parentInjector != null ? this.state.parentInjector : this.state.injector;
                this.state = retryResources.state;
                Iterator<Replay<Resources, ?, Exception>> iterator = this.replays.iterator();
                while (iterator.hasNext()) {
                    Object ret = iterator.next().replay(this);
                    if (iterator.hasNext()) continue;
                    this.lastResult = ret;
                }
                return replay.replay(this);
            });
        }
        catch (RuntimeException th2) {
            this.lastException = th2;
            this.log(LogLevel.WARN, ABORT_DUE_TO_EXCEPTION, th2);
            this.abort();
            throw th2;
        }
        catch (Throwable th2) {
            this.lastException = th2;
            this.log(LogLevel.WARN, ABORT_DUE_TO_EXCEPTION, th2);
            this.abort();
            throw new SystemException(th2);
        }
    }

    public synchronized <R extends Resources, E extends Exception> void submit(ConsumerWithException<R, E> work) {
        this.play(new Replay(work));
    }

    public synchronized <T extends Resources, R, E extends Exception> R submit(FunctionWithException<T, R, E> work) {
        return this.play(new Replay<T, R, E>(work));
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Resources, R, E extends Exception> R play(Replay<T, R, E> replay) {
        R ret = null;
        boolean topLevel = !this.submitting;
        this.submitting = true;
        Deque<Resources> deque = activeResources.get();
        try {
            if (deque == null) {
                deque = new LinkedList<Resources>();
                activeResources.set(deque);
            }
            deque.push(this);
            try {
                ret = replay.replay(this);
            }
            catch (Throwable th) {
                this.lastException = th;
                if (this.replayable != null && this.replayable.booleanValue() || this.replayable == null && this.resourceManager.isReplayable()) {
                    ret = this.replay(th, replay);
                }
                this.log(LogLevel.WARN, ABORT_DUE_TO_EXCEPTION, th);
                this.abort();
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                throw new SystemException(th);
            }
            this.lastResult = ret;
        }
        finally {
            if (topLevel) {
                this.submitting = false;
                if (!this.isAborted()) {
                    this.replays.add(replay);
                }
            }
            deque.remove(this);
            if (deque.isEmpty()) {
                activeResources.remove();
            }
        }
        return ret;
    }

    private void log(LogLevel level, String msg, Throwable th) {
        Provision provision = this.resourceManager.getInstance(Provision.class);
        provision.log(logger, level, msg, th);
    }

    public synchronized <R> R commit() {
        Object ret;
        block8: {
            ret = null;
            try {
                ret = this._commit();
            }
            catch (Exception th) {
                if (this.replayable != null && this.replayable.booleanValue() || this.replayable == null && this.resourceManager.isReplayable()) {
                    ret = this.replay(th, new Replay(res -> this._commit()));
                    break block8;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                throw new SystemException(th);
            }
            finally {
                if (this.isCommitted()) {
                    this.cleanup();
                    this.state.setState(ResourcesState.State.COMMITTED);
                }
            }
        }
        return (R)ret;
    }

    private <R> R _commit() {
        ResourceProvider resourceProvider;
        Object ret = null;
        if (this.resourceManager == null) {
            return null;
        }
        if (this.isAborted() || this.isCommitted()) {
            return (R)this.lastResult;
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Already closed");
        }
        for (int i = 0; i < this.state.getResourceProviders().size(); ++i) {
            resourceProvider = this.state.getResourceProviders().get(i);
            resourceProvider.onCommit(this);
            if (!this.isAborted()) continue;
            return (R)this.lastResult;
        }
        for (ResourceProvider p : this.getExternalResourceProviders()) {
            p.onCommit(this);
        }
        for (int i = 0; i < this.state.getResourceProviders().size(); ++i) {
            resourceProvider = this.state.getResourceProviders().get(i);
            try {
                resourceProvider.afterCommit(this);
                continue;
            }
            catch (Exception th) {
                Logger.suppress(th);
            }
        }
        this.state.setState(ResourcesState.State.COMMITTED);
        ret = this.lastResult;
        return (R)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Resources abort() {
        try {
            if (this.resourceManager == null) {
                Resources resources = this;
                return resources;
            }
            if (!this.isAborted()) {
                ResourceProvider resourceProvider;
                for (int i = 0; i < this.state.getResourceProviders().size(); ++i) {
                    resourceProvider = this.state.getResourceProviders().get(i);
                    try {
                        resourceProvider.onAbort(this);
                        continue;
                    }
                    catch (Exception th) {
                        Logger.suppress(th);
                    }
                }
                for (ResourceProvider p : this.getExternalResourceProviders()) {
                    try {
                        p.onAbort(this);
                    }
                    catch (Exception th) {
                        Logger.suppress(th);
                    }
                }
                this.state.setState(ResourcesState.State.ABORTED);
                for (int i = 0; i < this.state.getResourceProviders().size(); ++i) {
                    resourceProvider = this.state.getResourceProviders().get(i);
                    try {
                        resourceProvider.afterAbort(this);
                        continue;
                    }
                    catch (Exception th) {
                        Logger.suppress(th);
                    }
                }
            }
        }
        finally {
            this.state.setState(ResourcesState.State.ABORTED);
            this.cleanup();
            this.state.setState(ResourcesState.State.ABORTED);
        }
        return this;
    }

    @Override
    public void close() throws Exception {
        if (!this.isOpen()) {
            return;
        }
        if (!this.isAborted()) {
            this.commit();
        } else {
            this.abort();
        }
    }

    public void cleanup() {
        try {
            for (ResourceProvider resourceProvider : this.state.getResourceProviders()) {
                resourceProvider.onClosed(this);
            }
            for (ResourceProvider p : this.getExternalResourceProviders()) {
                p.onClosed(this);
            }
        }
        catch (Exception ex) {
            this.log(LogLevel.TRACE, ex.getMessage(), ex);
        }
        this.state.cleanup();
        this.configurator.clear();
        this.replays.clear();
        this.lastResult = null;
        this.submitting = false;
        this.preOpen = null;
    }

    public <T extends Provision> T provision() {
        return (T)this.getInstance(Provision.class);
    }

    private static class Replay<T extends Resources, R, E extends Exception> {
        ConsumerWithException<T, E> consumer;
        FunctionWithException<T, R, E> function;

        Replay(ConsumerWithException<T, E> work) {
            this.consumer = work;
        }

        Replay(FunctionWithException<T, R, E> work) {
            this.function = work;
        }

        R replay(T res) throws E {
            if (this.consumer != null) {
                this.consumer.accept(res);
                return null;
            }
            return this.function.apply(res);
        }
    }
}

