/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import java.util.Map;
import java.util.function.Consumer;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Atom;
import net.e6tech.elements.common.resources.Bootstrap;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.script.AbstractScriptBase;
import net.e6tech.elements.common.util.SystemException;

public abstract class ResourceManagerScript
extends AbstractScriptBase<ResourceManager> {
    private static Logger logger = Logger.getLogger();
    private Bootstrap bootstrap;

    public Bootstrap getBootstrap() {
        if (this.bootstrap != null) {
            return this.bootstrap;
        }
        if (this.hasVariable("bootstrap")) {
            this.bootstrap = (Bootstrap)((Object)this.getVariable("bootstrap"));
        } else {
            this.bootstrap = new Bootstrap((ResourceManager)this.getShell());
            ((ResourceManager)this.getShell()).getScripting().put("bootstrap", (Object)this.bootstrap);
        }
        return this.bootstrap;
    }

    public Object invokeMethod(String name, Object args) {
        try {
            return this.getMetaClass().invokeMethod((Object)this, name, args);
        }
        catch (MissingMethodException ex) {
            if (ex.getArguments().length > 0 && ex.getArguments()[0] instanceof Closure) {
                Closure closure = (Closure)ex.getArguments()[0];
                if (closure.getDelegate() instanceof Closure) {
                    Closure outerClosure = (Closure)closure.getDelegate();
                    if (outerClosure.getDelegate() instanceof Atom) {
                        Atom atom = (Atom)outerClosure.getDelegate();
                        Object value = atom.get(name);
                        if (value == null) {
                            logger.warn("component({}) trying to insert Closure with no instance named {}", atom.getName(), name);
                        }
                        return atom.put(name, (Object)closure);
                    }
                    throw ex;
                }
                throw ex;
            }
            throw ex;
        }
        catch (Exception ex) {
            throw new SystemException(ex);
        }
    }

    public <T> T bind(T resource) {
        return ((ResourceManager)this.getShell()).bind(resource);
    }

    public <T> T bind(Class<T> cls, T resource) {
        return ((ResourceManager)this.getShell()).bind(cls, resource);
    }

    public <T> T rebind(T resource) {
        return ((ResourceManager)this.getShell()).rebind(resource);
    }

    public <T> T rebind(Class<T> cls, T resource) {
        return ((ResourceManager)this.getShell()).rebind(cls, resource);
    }

    public void bindClass(Class a, Class b) {
        ((ResourceManager)this.getShell()).bindClass(a, b);
    }

    public <T> T bindNamedInstance(String name, Class<T> a, T b) {
        return ((ResourceManager)this.getShell()).bindNamedInstance(a, name, b);
    }

    public <T> T bindNamedInstance(String name, T b) {
        return (T)((ResourceManager)this.getShell()).bindNamedInstance(b.getClass(), name, b);
    }

    public <T> T rebindNamedInstance(String name, Class<T> a, T b) {
        return ((ResourceManager)this.getShell()).rebindNamedInstance(a, name, b);
    }

    public <T> T rebindNamedInstance(String name, T b) {
        return (T)((ResourceManager)this.getShell()).rebindNamedInstance(b.getClass(), name, b);
    }

    public <T> T registerBean(String name, Object instance) {
        return ((ResourceManager)this.getShell()).registerBean(name, instance);
    }

    public void unregisterBean(String name) {
        ((ResourceManager)this.getShell()).unregisterBean(name);
    }

    public <T> T getBean(String name) {
        return ((ResourceManager)this.getShell()).getBean(name);
    }

    public Atom atom(Closure closure) {
        return this.atom(null, closure);
    }

    public AtomBuilder prototype(String name) {
        return new AtomBuilder(name, true, (ResourceManager)this.getShell());
    }

    public Atom prototype(String name, Closure closure) {
        return this.prototype(name).build(closure);
    }

    public Atom prototype(String name, String prototypePath, Closure closure) {
        return this.prototype(name).from(prototypePath).build(closure);
    }

    public AtomBuilder atom(String name) {
        return new AtomBuilder(name, false, (ResourceManager)this.getShell());
    }

    public Atom atom(String name, Closure closure) {
        return this.atom(name).build(closure);
    }

    public Atom atom(String name, String prototypePath, Closure closure) {
        return this.atom(name).from(prototypePath).build(closure);
    }

    public Bootstrap boot(Object bootScript, Object ... components) {
        this.getBootstrap().boot(bootScript, components);
        return this.bootstrap;
    }

    public static class AtomBuilder {
        private Map<String, Object> settings;
        private String name;
        private Closure closure;
        private ResourceManager resourceManager;
        private String prototypePath;
        private boolean prototype = false;

        public AtomBuilder(String name, boolean prototype, ResourceManager resourceManager) {
            this.name = name;
            this.prototype = prototype;
            this.resourceManager = resourceManager;
        }

        public AtomBuilder settings(Map<String, Object> settings) {
            this.settings = settings;
            return this;
        }

        public AtomBuilder from(String prototypePath) {
            this.prototypePath = prototypePath;
            return this;
        }

        public AtomBuilder prototype(boolean p) {
            this.prototype = p;
            return this;
        }

        public Atom build(Closure closure) {
            this.closure = closure;
            return this.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Atom build() {
            Atom prototypeAtom;
            Atom existing = this.resourceManager.getAtom(this.name);
            if (existing != null) {
                return existing;
            }
            boolean hasPreviousSettings = this.resourceManager.getScripting().containsKey("__atom_override_settings");
            boolean hasPreviousName = this.resourceManager.getScripting().containsKey("__atom_override_name");
            Map previousSettings = (Map)this.resourceManager.getScripting().get("__atom_override_settings");
            String previousName = (String)this.resourceManager.getScripting().get("__atom_override_name");
            try {
                if (this.settings != null) {
                    this.resourceManager.getScripting().put("__atom_override_settings", this.settings);
                }
                if (!this.prototype) {
                    this.resourceManager.getScripting().put("__atom_override_name", this.name);
                }
                prototypeAtom = this.prototypePath != null ? (Atom)this.resourceManager.exec(this.prototypePath) : null;
            }
            finally {
                if (hasPreviousSettings) {
                    this.resourceManager.getScripting().put("__atom_override_settings", previousSettings);
                } else if (this.settings != null) {
                    this.resourceManager.getScripting().remove("__atom_override_settings");
                }
                if (!this.prototype) {
                    if (hasPreviousName) {
                        this.resourceManager.getScripting().put("__atom_override_name", previousName);
                    } else {
                        this.resourceManager.getScripting().remove("__atom_override_name");
                    }
                }
            }
            return this.resourceManager.createAtom(this.name, this.atomConsumer(), prototypeAtom, this.prototype);
        }

        private Consumer<Atom> atomConsumer() {
            if (this.closure == null) {
                return atom -> {};
            }
            return atom -> {
                if (this.closure != null) {
                    atom.setScriptLoader(this.closure.getClass().getClassLoader());
                } else {
                    atom.setScriptLoader(this.resourceManager.getScripting().getScriptLoader());
                }
                Closure clonedClosure = this.closure.rehydrate(atom, this.closure.getOwner(), this.closure.getOwner());
                clonedClosure.setResolveStrategy(1);
                if (this.settings != null) {
                    atom.setDefaultSettings(this.settings);
                }
                clonedClosure.call(atom);
                this.resourceManager.addCleanup(() -> {
                    clonedClosure.setDelegate(null);
                    Object owner = clonedClosure.getOwner();
                    if (owner instanceof Closure) {
                        ((Closure)owner).setDelegate(null);
                    }
                });
            };
        }
    }
}

