/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.reflection;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.CacheProvider;
import com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.Primitives;
import net.e6tech.elements.common.reflection.Resolver;
import net.e6tech.elements.common.util.SystemException;

public class ObjectConverter {
    public static final ObjectMapper mapper = new ObjectMapper();
    private Resolver resolver;
    private InstanceCreationListener listener;
    private ObjectMapper objectMapper;

    public static Class loadClass(ClassLoader loader, String name) throws ClassNotFoundException {
        if (Primitives.isPrimitive(name)) {
            return Primitives.get(name);
        }
        return loader.loadClass(name);
    }

    public static Type conversionType(Method getterOrSetter) throws IOException {
        Type returnType = getterOrSetter.getGenericReturnType();
        if (!returnType.equals(Void.TYPE)) {
            if (getterOrSetter.getParameterTypes().length != 0) {
                throw new IllegalArgumentException("Method " + getterOrSetter.getName() + " must be a getter");
            }
            return returnType;
        }
        Type[] parameters = getterOrSetter.getGenericParameterTypes();
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Method " + getterOrSetter.getName() + " must be a setter");
        }
        return parameters[0];
    }

    protected static Object resolve(Resolver resolver, Object value) {
        String exp;
        if (resolver != null && value instanceof String && (exp = ((String)value).trim()).startsWith("^")) {
            while (exp.startsWith("^")) {
                exp = exp.substring(1);
            }
            return resolver.resolve(exp);
        }
        return value;
    }

    public ObjectConverter() {
    }

    public ObjectConverter(Resolver resolver) {
        this.resolver = resolver;
    }

    public ObjectConverter(Resolver resolver, InstanceCreationListener listener) {
        this.resolver = resolver;
        this.listener = listener;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public InstanceCreationListener getListener() {
        return this.listener;
    }

    public void setListener(InstanceCreationListener listener) {
        this.listener = listener;
    }

    public Object convert(Object from, Method getterOrSetter, InstanceCreationListener listener) throws IOException {
        this.listener = listener;
        return this.convert(from, ObjectConverter.conversionType(getterOrSetter));
    }

    public Object convert(Object from, Method getterOrSetter) throws IOException {
        return this.convert(from, ObjectConverter.conversionType(getterOrSetter));
    }

    public Object convert(Object from, Method getterOrSetter, Resolver resolver, InstanceCreationListener listener) throws IOException {
        this.resolver = resolver;
        this.listener = listener;
        this.objectMapper = null;
        return this.convert(from, ObjectConverter.conversionType(getterOrSetter));
    }

    public Object convert(Object from, Field field) throws IOException {
        return this.convert(from, field.getGenericType());
    }

    public Object convert(Object from, Field field, InstanceCreationListener listener) throws IOException {
        this.listener = listener;
        return this.convert(from, field.getGenericType());
    }

    public Object convert(Object from, Field field, Resolver resolver, InstanceCreationListener listener) throws IOException {
        this.resolver = resolver;
        this.listener = listener;
        this.objectMapper = null;
        return this.convert(from, field.getGenericType());
    }

    public Object convert(Object from, Type toType, InstanceCreationListener listener) throws IOException {
        this.listener = listener;
        return this.convert(from, toType);
    }

    public Object convert(Object from, Type toType) throws IOException {
        Object converted;
        block9: {
            Class elementType;
            Class enclosedType;
            block10: {
                ObjectMapper objectMapper;
                block8: {
                    if (from == null) {
                        return null;
                    }
                    converted = null;
                    objectMapper = this.createObjectMapper();
                    if (!(toType instanceof Class)) break block8;
                    converted = this.convert(objectMapper, from, (Class)toType);
                    break block9;
                }
                ParameterizedType parametrized = (ParameterizedType)toType;
                enclosedType = (Class)parametrized.getRawType();
                if (ObjectConverter.isMapOrCollection(enclosedType)) {
                    JavaType ctype = TypeFactory.defaultInstance().constructType(toType);
                    String str = objectMapper.writeValueAsString(from);
                    converted = objectMapper.readValue(str, ctype);
                } else {
                    converted = this.convert(objectMapper, from, enclosedType);
                }
                if (this.listener == null || !ObjectConverter.isMapOrCollection(enclosedType)) break block9;
                Type type = parametrized.getActualTypeArguments()[0];
                elementType = null;
                if (type instanceof Class) {
                    elementType = (Class)type;
                } else {
                    ParameterizedType ptype = (ParameterizedType)type;
                    if (ptype.getRawType() instanceof Class) {
                        elementType = (Class)ptype.getRawType();
                    }
                }
                if (!Collection.class.isAssignableFrom(enclosedType)) break block10;
                Iterator iter1 = ((Collection)from).iterator();
                Iterator iter2 = ((Collection)converted).iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    this.listener.instanceCreated(iter1.hasNext(), elementType, iter2.next());
                }
                break block9;
            }
            if (!Map.class.isAssignableFrom(enclosedType)) break block9;
            Map fromMap = (Map)from;
            Map convertedMap = (Map)converted;
            for (Map.Entry entry : convertedMap.entrySet()) {
                Object old = fromMap.get(entry.getKey());
                this.listener.instanceCreated(old, elementType, entry.getValue());
            }
        }
        return converted;
    }

    private static boolean isMapOrCollection(Class clazz) {
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }

    private Object convert(ObjectMapper objectMapper, Object val, Class toType) throws IOException {
        Object value = val;
        Class<?> fromType = value.getClass();
        if (toType.isArray()) {
            if (fromType.isArray() && fromType.getComponentType().equals(toType.getComponentType())) {
                return value;
            }
            if (value instanceof Collection) {
                Collection coll = (Collection)value;
                Object array = Array.newInstance(toType.getComponentType(), coll.size());
                Iterator iterator = coll.iterator();
                int index = 0;
                while (iterator.hasNext()) {
                    Object member = iterator.next();
                    Array.set(array, index, this.convert(member, toType.getComponentType()));
                    ++index;
                }
                return array;
            }
            return objectMapper.convertValue(val, toType);
        }
        if (toType.isAssignableFrom(fromType)) {
            return value;
        }
        if (toType.isPrimitive() || fromType.isPrimitive()) {
            boolean needConversion = toType.equals(fromType) ? false : (toType.isPrimitive() ? this.shouldConvertPrimitive(toType, fromType) : this.shouldConvertPrimitive(fromType, toType));
            if (!needConversion) {
                return value;
            }
        } else {
            if (toType.equals(String.class)) {
                return value.toString();
            }
            if (value instanceof String && !toType.isAssignableFrom(Class.class)) {
                try {
                    if (this.resolver != null && value.toString().trim().startsWith("^")) {
                        return this.resolver.resolve(value.toString());
                    }
                    String str = objectMapper.writeValueAsString(value);
                    value = objectMapper.readValue(str, toType);
                    return value;
                }
                catch (Exception e) {
                    Logger.suppress(e);
                    try {
                        Class<?> cls = this.getClass().getClassLoader().loadClass((String)value);
                        value = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        if (this.listener != null && value != null) {
                            this.listener.instanceCreated(value, toType, value);
                        }
                        return value;
                    }
                    catch (Exception e1) {
                        throw new SystemException(e1);
                    }
                }
            }
        }
        String str = objectMapper.writeValueAsString(value);
        return objectMapper.readValue(str, toType);
    }

    private Collection convertCollection(ObjectMapper objectMapper, Collection value, Class<? extends Collection> collectionType, Class elementType) throws IOException {
        CollectionType ctype = TypeFactory.defaultInstance().constructCollectionType(collectionType, elementType);
        String str = objectMapper.writeValueAsString((Object)value);
        Collection converted = (Collection)objectMapper.readValue(str, (JavaType)ctype);
        if (this.listener != null) {
            Iterator iter1 = value.iterator();
            Iterator iter2 = converted.iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                this.listener.instanceCreated(iter1.hasNext(), elementType, iter2.next());
            }
        }
        return converted;
    }

    private Map convertMap(ObjectMapper objectMapper, Map value, Type type) throws IOException {
        JavaType ctype = TypeFactory.defaultInstance().constructType(type);
        String str = objectMapper.writeValueAsString((Object)value);
        Map converted = (Map)objectMapper.readValue(str, ctype);
        return converted;
    }

    protected boolean shouldConvertPrimitive(Class c1, Class c2) {
        return !(c1.equals(Boolean.TYPE) && Boolean.class.equals((Object)c2) || c1.equals(Character.TYPE) && Character.class.equals((Object)c2) || c1.equals(Byte.TYPE) && Byte.class.equals((Object)c2) || c1.equals(Short.TYPE) && Short.class.equals((Object)c2) || c1.equals(Integer.TYPE) && Integer.class.equals((Object)c2) || c1.equals(Long.TYPE) && Long.class.equals((Object)c2) || c1.equals(Float.TYPE) && Float.class.equals((Object)c2) || c1.equals(Double.TYPE) && Double.class.equals((Object)c2));
    }

    public ObjectMapper createObjectMapper() {
        if (this.resolver == null) {
            return mapper;
        }
        if (this.objectMapper != null) {
            return this.objectMapper;
        }
        this.objectMapper = new ObjectMapper(null, null, (DefaultDeserializationContext)new MyDefaultDeserializationContext(this.resolver, (DeserializerFactory)new MyBeanDeserializerFactory(this.resolver, new DeserializerFactoryConfig())));
        this.objectMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.objectMapper.addHandler((DeserializationProblemHandler)new MyDeserializationProblemHandler(this.resolver));
        return this.objectMapper;
    }

    static Object handleMissingInstantiator(Resolver resolver, Class<?> instClass, JsonParser p) throws IOException {
        if (resolver != null) {
            String value = p.getText();
            Object resolved = ObjectConverter.resolve(resolver, value);
            if (resolved == null) {
                return resolved;
            }
            if (instClass.isAssignableFrom(resolved.getClass())) {
                return resolved;
            }
            if (ClassLoader.class.isAssignableFrom(instClass)) {
                return resolved.getClass().getClassLoader();
            }
        }
        return null;
    }

    static {
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    public static class MyDefaultDeserializationContext
    extends DefaultDeserializationContext {
        private static final long serialVersionUID = 1L;
        transient Resolver resolver;

        public MyDefaultDeserializationContext(Resolver resolver, DeserializerFactory df) {
            super(df, null);
            this.resolver = resolver;
        }

        private MyDefaultDeserializationContext(MyDefaultDeserializationContext src, DeserializationConfig config, JsonParser p, InjectableValues values) {
            super((DefaultDeserializationContext)src, config, p, values);
            this.resolver = src.resolver;
        }

        private MyDefaultDeserializationContext(MyDefaultDeserializationContext src) {
            super((DefaultDeserializationContext)src);
            this.resolver = src.resolver;
        }

        private MyDefaultDeserializationContext(MyDefaultDeserializationContext src, DeserializerFactory factory) {
            super((DefaultDeserializationContext)src, factory);
            this.resolver = src.resolver;
        }

        private MyDefaultDeserializationContext(MyDefaultDeserializationContext src, DeserializationConfig config) {
            super((DefaultDeserializationContext)src, config);
            this.resolver = src.resolver;
        }

        private MyDefaultDeserializationContext(MyDefaultDeserializationContext src, CacheProvider cp) {
            super((DefaultDeserializationContext)src, cp);
            this.resolver = src.resolver;
        }

        public DefaultDeserializationContext copy() {
            return new MyDefaultDeserializationContext(this);
        }

        public DefaultDeserializationContext createInstance(DeserializationConfig config, JsonParser p, InjectableValues values) {
            return new MyDefaultDeserializationContext(this, config, p, values);
        }

        public DefaultDeserializationContext createDummyInstance(DeserializationConfig config) {
            return new MyDefaultDeserializationContext(this, config);
        }

        public DefaultDeserializationContext with(DeserializerFactory factory) {
            return new MyDefaultDeserializationContext(this, factory);
        }

        public DefaultDeserializationContext withCaches(CacheProvider cacheProvider) {
            return new MyDefaultDeserializationContext(this, cacheProvider);
        }

        public Object readRootValue(JsonParser p, JavaType valueType, JsonDeserializer<Object> deser, Object valueToUpdate) throws IOException {
            if (this.resolver != null && p.getText().trim().startsWith("^")) {
                return this.resolver.resolve(p.getText().trim());
            }
            return super.readRootValue(p, valueType, deser, valueToUpdate);
        }

        public Object handleMissingInstantiator(Class<?> instClass, ValueInstantiator valueInst, JsonParser p, String msg, Object ... msgArgs) throws IOException {
            if (this.resolver != null) {
                return ObjectConverter.handleMissingInstantiator(this.resolver, instClass, p);
            }
            return super.handleMissingInstantiator(instClass, valueInst, p, msg, msgArgs);
        }
    }

    public static class MyDeserializationProblemHandler
    extends DeserializationProblemHandler {
        Resolver resolver;

        public MyDeserializationProblemHandler(Resolver resolver) {
            this.resolver = resolver;
        }

        public Object handleMissingInstantiator(DeserializationContext ctxt, Class<?> instClass, ValueInstantiator valueInsta, JsonParser p, String msg) throws IOException {
            if (this.resolver != null) {
                return ObjectConverter.handleMissingInstantiator(this.resolver, instClass, p);
            }
            return super.handleMissingInstantiator(ctxt, instClass, valueInsta, p, msg);
        }
    }

    public static class MyUntypedObjectDeserializer
    extends UntypedObjectDeserializer {
        Resolver resolver;

        public MyUntypedObjectDeserializer(Resolver resolver, JavaType listType, JavaType mapType) {
            super(listType, mapType);
            this.resolver = resolver;
        }

        protected MyUntypedObjectDeserializer(UntypedObjectDeserializer base, boolean nonMerging) {
            super(base, nonMerging);
        }

        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object value = super.deserialize(p, ctxt);
            return ObjectConverter.resolve(this.resolver, value);
        }
    }

    public static class MyTypeReference
    extends TypeReference<Object> {
        private Type type;

        public MyTypeReference(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }
    }

    public static class MyBeanDeserializerFactory
    extends BeanDeserializerFactory {
        transient Resolver resolver;

        public MyBeanDeserializerFactory(Resolver resolver, DeserializerFactoryConfig config) {
            super(config);
            this.resolver = resolver;
        }

        public DeserializerFactory withConfig(DeserializerFactoryConfig config) {
            if (this._factoryConfig == config) {
                return this;
            }
            return new MyBeanDeserializerFactory(this.resolver, config);
        }

        public JsonDeserializer<?> findDefaultDeserializer(DeserializationContext ctxt, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
            JsonDeserializer deserializer = super.findDefaultDeserializer(ctxt, type, beanDesc);
            if (deserializer instanceof UntypedObjectDeserializer) {
                JavaType mt;
                JavaType lt;
                DeserializationConfig config = ctxt.getConfig();
                if (this._factoryConfig.hasAbstractTypeResolvers()) {
                    lt = this._findRemappedType(config, List.class);
                    mt = this._findRemappedType(config, Map.class);
                } else {
                    mt = null;
                    lt = null;
                }
                return new MyUntypedObjectDeserializer(this.resolver, lt, mt);
            }
            return deserializer;
        }
    }

    @FunctionalInterface
    public static interface InstanceCreationListener {
        public void instanceCreated(Object var1, Class var2, Object var3);
    }
}

