/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.notification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import net.e6tech.elements.common.notification.Notification;
import net.e6tech.elements.common.notification.NotificationListener;
import net.e6tech.elements.common.subscribe.Broadcast;
import net.e6tech.elements.common.subscribe.Notice;
import net.e6tech.elements.common.subscribe.Subscriber;

public class NotificationCenter
implements Broadcast {
    private Map<Object, List<NotificationListener>> srcNotificationListeners = new ConcurrentHashMap<Object, List<NotificationListener>>();
    private Map<Class, List<NotificationListener>> notificationListeners = new ConcurrentHashMap<Class, List<NotificationListener>>();
    Map<String, List<Subscriber>> subscribers = new ConcurrentHashMap<String, List<Subscriber>>();
    List<Broadcast> broadcasts = new CopyOnWriteArrayList<Broadcast>();
    Executor executor = runnable -> new Thread(runnable).start();

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void addSourceNotificationListener(Object src, NotificationListener listener) {
        List listeners = this.srcNotificationListeners.computeIfAbsent(src, n -> new CopyOnWriteArrayList());
        listeners.add(listener);
    }

    public void removeSourceNotificationListener(Object src, NotificationListener listener) {
        List listeners = this.srcNotificationListeners.computeIfAbsent(src, n -> new CopyOnWriteArrayList());
        listeners.remove(listener);
    }

    public <T extends Notification> void addNotificationListener(Class<T> cls, NotificationListener<T> listener) {
        List listeners = this.notificationListeners.computeIfAbsent(cls, n -> new CopyOnWriteArrayList());
        listeners.add(listener);
    }

    public <T extends Notification> void removeNotificationListener(Class<T> cls, NotificationListener<T> listener) {
        List listeners = this.notificationListeners.computeIfAbsent(cls, n -> new CopyOnWriteArrayList());
        listeners.remove(listener);
    }

    public void fireNotification(Notification notification) {
        List<NotificationListener> listeners;
        if (notification.source() != null && (listeners = this.srcNotificationListeners.get(notification.source())) != null) {
            listeners.forEach(listener -> listener.onEvent(notification));
        }
        Class<?> cls = notification.getClass();
        while (!cls.equals(Object.class)) {
            List<NotificationListener> listeners2 = this.notificationListeners.get(cls);
            if (listeners2 != null) {
                listeners2.forEach(listener -> listener.onEvent(notification));
                break;
            }
            cls = cls.getSuperclass();
        }
    }

    public List<NotificationListener> getNotificationListeners(Notification notification) {
        List<NotificationListener> list;
        ArrayList<NotificationListener> listeners = new ArrayList<NotificationListener>();
        if (notification.source() != null && (list = this.srcNotificationListeners.get(notification.source())) != null) {
            listeners.addAll(list);
        }
        if ((list = this.notificationListeners.get(notification.getClass())) != null) {
            listeners.addAll(list);
        }
        return list == null ? Collections.emptyList() : list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(String topic, Subscriber subscriber) {
        List list = this.subscribers.computeIfAbsent(topic, key -> new CopyOnWriteArrayList());
        List list2 = list;
        synchronized (list2) {
            list.add(subscriber);
        }
        for (Broadcast broadcast : this.broadcasts) {
            broadcast.subscribe(topic, subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(String topic, Subscriber subscriber) {
        List list = this.subscribers.computeIfAbsent(topic, key -> new CopyOnWriteArrayList());
        List list2 = list;
        synchronized (list2) {
            list.remove(subscriber);
        }
        for (Broadcast broadcast : this.broadcasts) {
            broadcast.unsubscribe(topic, subscriber);
        }
    }

    @Override
    public void publish(Notice<?> notice) {
        for (Broadcast broadcast : this.broadcasts) {
            broadcast.publish(notice);
        }
    }

    public void addBroadcast(Broadcast broadcast) {
        this.broadcasts.add(broadcast);
        for (Map.Entry<String, List<Subscriber>> entry : this.subscribers.entrySet()) {
            for (Subscriber subscriber : entry.getValue()) {
                broadcast.subscribe(entry.getKey(), subscriber);
            }
        }
    }

    public void removeBroadcast(Broadcast broadcast) {
        this.broadcasts.remove(broadcast);
        for (Map.Entry<String, List<Subscriber>> entry : this.subscribers.entrySet()) {
            for (Subscriber subscriber : entry.getValue()) {
                broadcast.unsubscribe(entry.getKey(), subscriber);
            }
        }
    }
}

