/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.interceptor;

import java.lang.reflect.Field;
import java.util.concurrent.ExecutionException;
import net.e6tech.elements.common.interceptor.AbstractBuilder;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.util.SystemException;

public class SingletonClassBuilder<T>
extends AbstractBuilder<Class<T>, SingletonClassBuilder<T>> {
    private Class<T> cls;
    private T singleton;

    public SingletonClassBuilder(Interceptor interceptor, Class<T> cls, T singleton) {
        super(interceptor, ctx -> ctx.invoke(singleton));
        this.cls = cls;
        this.singleton = singleton;
    }

    @Override
    public Class<T> build() {
        if (this.singleton == null) {
            throw new IllegalArgumentException("target cannot be null");
        }
        try {
            Class proxyClass = (Class)this.interceptor.singletonClasses.get(this.cls, () -> this.interceptor.loadClass(this.interceptor.newSingletonBuilder(this.cls).make(), this.cls, this.classLoader));
            Field field = proxyClass.getDeclaredField("handler");
            field.setAccessible(true);
            Interceptor.InterceptorHandlerWrapper wrapper = new Interceptor.InterceptorHandlerWrapper(this.interceptor, proxyClass, null, this.singleton, this.handler, this.listener, this.newObject);
            field.set(null, wrapper);
            return proxyClass;
        }
        catch (ExecutionException e) {
            throw new SystemException(e.getCause());
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }
}

