/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.interceptor;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.e6tech.elements.common.util.SystemException;

public class CallFrame {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private Object proxyObject;
    private Object target;
    private MethodHandle handle;
    private Object[] arguments;
    private Method method;
    private Invoke invoke;

    CallFrame() {
    }

    CallFrame initialize(Object proxyObject, Object target, MethodHandle handle, Method method, Object[] arguments) {
        this.proxyObject = proxyObject;
        this.target = target;
        this.handle = handle;
        this.method = method;
        this.arguments = arguments == null ? EMPTY_ARGS : arguments;
        this.invoke = Modifier.isPublic(this.getMethod().getModifiers()) ? t -> handle.bindTo(t).invokeWithArguments(arguments) : t -> this.getMethod().invoke(t, arguments);
        return this;
    }

    void clear() {
        this.proxyObject = null;
        this.target = null;
        this.handle = null;
        this.method = null;
        this.arguments = EMPTY_ARGS;
        this.invoke = null;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public Object getProxyObject() {
        return this.proxyObject;
    }

    public Object getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public MethodHandle getMethodHandle() {
        return this.handle;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.getMethod().getAnnotation(annotationClass);
    }

    public Object invoke() {
        return this.invoke(this.target);
    }

    public Object invoke(Object anotherTarget) {
        try {
            return this.invoke.apply(anotherTarget);
        }
        catch (InvocationTargetException th) {
            throw new SystemException(th.getTargetException());
        }
        catch (Throwable th) {
            throw new SystemException(th);
        }
    }

    @FunctionalInterface
    static interface Invoke {
        public Object apply(Object var1) throws Throwable;
    }
}

