/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.federation;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class Member {
    private String memberId;
    private String name;
    private String address;
    private long expiration;
    private String toString;
    private List<String> services = new LinkedList<String>();

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address.trim();
        while (this.address.endsWith("/")) {
            this.address = this.address.substring(0, this.address.length() - 1);
        }
    }

    public List<String> getServices() {
        return this.services;
    }

    public void setServices(List<String> services) {
        this.services = services;
    }

    public static String formatISODateTime(long timeMillis, ZoneId zoneId) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeMillis), zoneId));
    }

    public Member memberId(String memberId) {
        this.setMemberId(memberId);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Member name(String name) {
        this.setName(name);
        return this;
    }

    public Member address(String address) {
        this.setAddress(address);
        return this;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
        this.toString = null;
    }

    public Member expiration(long exp) {
        this.setExpiration(exp);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member member = (Member)o;
        return this.getMemberId().equals(member.getMemberId()) && this.getAddress().equals(member.getAddress());
    }

    public int hashCode() {
        return Objects.hash(this.getMemberId(), this.getAddress());
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = "memberId=" + this.getMemberId() + ",hostAddress='" + this.getAddress() + "',expiration=" + Member.formatISODateTime(this.expiration, ZoneId.systemDefault());
        }
        return this.toString;
    }
}

