/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.concurrent;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.lmax.disruptor.util.DaemonThreadFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.e6tech.elements.common.util.SystemException;

public class DisruptorPool {
    static Handler defaultHandler = thread -> thread.interrupt();
    private Monitor monitor = new Monitor();
    Disruptor<Event> disruptor;
    private int bufferSize = 1024;
    private int handlerSize = Runtime.getRuntime().availableProcessors() * 2;
    private int initialMonitorCapacity = 16;
    private ExecutorService executorService;

    public Disruptor<Event> getDisruptor() {
        return this.disruptor;
    }

    public void setDisruptor(Disruptor<Event> disruptor) {
        this.disruptor = disruptor;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getHandlerSize() {
        return this.handlerSize;
    }

    public void setHandlerSize(int handlerSize) {
        this.handlerSize = handlerSize;
    }

    public int getInitialMonitorCapacity() {
        return this.initialMonitorCapacity;
    }

    public void setInitialMonitorCapacity(int initialMonitorCapacity) {
        this.initialMonitorCapacity = initialMonitorCapacity;
    }

    public synchronized void start() {
        if (!this.monitor.isAlive()) {
            this.monitor.capacity = this.initialMonitorCapacity;
            this.monitor.start();
        }
        if (this.disruptor != null) {
            return;
        }
        this.disruptor = new Disruptor(() -> new Event(), this.getBufferSize(), (ThreadFactory)DaemonThreadFactory.INSTANCE, ProducerType.MULTI, (WaitStrategy)new YieldingWaitStrategy());
        WorkHandler handler = Event::handle;
        WorkHandler[] workers = new WorkHandler[this.getHandlerSize()];
        for (int i = 0; i < workers.length; ++i) {
            workers[i] = handler;
        }
        this.disruptor.handleEventsWithWorkerPool(workers).then(new EventHandler[]{(event, sequence, endOfBatch) -> event.clear()});
        this.disruptor.start();
    }

    public synchronized void restart() {
        this.shutdown();
        this.start();
    }

    public synchronized void shutdown() {
        if (this.disruptor != null) {
            this.disruptor.shutdown();
            this.disruptor = null;
        }
        if (this.monitor.isAlive()) {
            this.monitor.shutdown = true;
            this.monitor.thread.interrupt();
        }
    }

    public RunnableWait run(Runnable runnable) {
        return this.run(runnable, null, 0L);
    }

    public RunnableWait run(Runnable runnable, long timeout) {
        return this.run(runnable, null, timeout);
    }

    public RunnableWait run(Runnable runnable, Handler handler) {
        return this.run(runnable, handler, 0L);
    }

    public RunnableWait run(Runnable runnable, Handler handler, long timeout) {
        RingBuffer ringBuffer = this.disruptor.getRingBuffer();
        long sequence = ringBuffer.next();
        Event event = (Event)ringBuffer.get(sequence);
        event.runnable = runnable;
        this.prepareEvent(event, handler, timeout);
        ringBuffer.publish(sequence);
        return new RunnableWait(event);
    }

    public <V> CallableWait<V> call(Callable<V> callable) {
        return this.call(callable, null, 0L);
    }

    public <V> CallableWait<V> call(Callable<V> callable, long timeout) {
        return this.call(callable, null, timeout);
    }

    public <V> CallableWait<V> call(Callable<V> callable, Handler<V> handler) {
        return this.call(callable, handler, 0L);
    }

    public <V> CallableWait<V> call(Callable<V> callable, Handler<V> handler, long timeout) {
        RingBuffer ringBuffer = this.disruptor.getRingBuffer();
        long sequence = ringBuffer.next();
        Event event = (Event)ringBuffer.get(sequence);
        event.callable = callable;
        this.prepareEvent(event, handler, timeout);
        ringBuffer.publish(sequence);
        return new CallableWait(event);
    }

    private void prepareEvent(Event event, Handler handler, long timeout) {
        if (handler != null) {
            event.handler = handler;
        }
        event.monitor = this.monitor;
        if (timeout < 0L) {
            timeout = 0L;
        }
        if (timeout > 0L) {
            event.expiration = System.currentTimeMillis() + timeout;
        }
    }

    @FunctionalInterface
    public static interface TimeoutHandler<V>
    extends Handler<V> {
        @Override
        public void timeout(Thread var1);
    }

    @FunctionalInterface
    public static interface CallbackHandler<V>
    extends Handler<V> {
        @Override
        public void callback(V var1);
    }

    @FunctionalInterface
    public static interface ExceptionHandler<V>
    extends Handler<V> {
        @Override
        public boolean exception(Exception var1);
    }

    public static interface Handler<V> {
        default public boolean exception(Exception exception) {
            return false;
        }

        default public void callback(V retVal) {
        }

        default public void timeout(Thread thread) {
            thread.interrupt();
        }
    }

    static class Monitor
    implements Runnable {
        private Thread thread;
        private int capacity = 16;
        List<Event> list;
        ReentrantLock lock = new ReentrantLock();
        private final Condition notEmpty = this.lock.newCondition();
        private volatile boolean shutdown = true;

        Monitor() {
        }

        public boolean isAlive() {
            if (this.thread == null) {
                return false;
            }
            return this.thread.isAlive();
        }

        public void start() {
            if (!this.shutdown) {
                return;
            }
            this.shutdown = false;
            this.list = new ArrayList<Event>(this.capacity);
            this.thread = new Thread(this);
            this.thread.start();
        }

        public void shutdown() {
            this.shutdown = true;
            this.thread.interrupt();
            this.list.clear();
            this.thread = null;
        }

        public void add(Event event) {
            this.add(event, true);
        }

        int binarySearch(List<Event> list, int l, int r, long exp) {
            if (r >= l) {
                int mid = l + (r - l) / 2;
                if (list.get(mid).expiration == exp) {
                    return mid;
                }
                if (list.get(mid).expiration > exp) {
                    return this.binarySearch(list, l, mid - 1, exp);
                }
                return this.binarySearch(list, mid + 1, r, exp);
            }
            return r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(Event event, boolean interrupt) {
            ReentrantLock lock = this.lock;
            int index = 0;
            lock.lock();
            try {
                int size = this.list.size();
                if (size > 0) {
                    int start = this.binarySearch(this.list, 0, this.list.size() - 1, event.expiration);
                    if (start < 0) {
                        start = 0;
                    } else if (start >= size) {
                        start = size - 1;
                    }
                    Event e = this.list.get(start);
                    index = e.expiration < event.expiration ? start + 1 : start;
                }
                this.list.add(index, event);
                this.notEmpty.signal();
            }
            finally {
                lock.unlock();
            }
            if (index == 0 && interrupt) {
                this.thread.interrupt();
            }
        }

        @Override
        public void run() {
            while (!this.shutdown) {
                Event event = null;
                try {
                    this.lock.lock();
                    while (this.list.size() == 0) {
                        this.notEmpty.await();
                    }
                    event = this.list.remove(0);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.lock.unlock();
                }
                if (event == null || this.monitor(event)) continue;
                this.add(event, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean monitor(Event event) {
            Event event2 = event;
            synchronized (event2) {
                boolean firstTime = true;
                while (!event.done) {
                    try {
                        long waitTime;
                        if (firstTime) {
                            waitTime = event.expiration - System.currentTimeMillis() - 1L;
                            firstTime = false;
                            if (waitTime == -1L) {
                                waitTime = 0L;
                            }
                        } else {
                            waitTime = event.expiration - System.currentTimeMillis();
                        }
                        if (waitTime > 0L) {
                            event.wait(waitTime);
                            continue;
                        }
                        Thread th = event.thread;
                        if (th == null) break;
                        event.handler.timeout(th);
                        event.thread = null;
                        break;
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                }
            }
            return true;
        }
    }

    private static class Event<V> {
        private Runnable runnable;
        private Callable<V> callable;
        private Handler<V> handler = defaultHandler;
        private Exception exception;
        private V returnValue;
        private volatile boolean done = false;
        private Thread thread;
        private long expiration;
        private Monitor monitor;

        private Event() {
        }

        void clear() {
            this.thread = null;
            this.done = false;
            this.returnValue = null;
            this.exception = null;
            this.runnable = null;
            this.callable = null;
            this.handler = defaultHandler;
            this.expiration = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handle() {
            if (this.expiration > 0L) {
                this.thread = Thread.currentThread();
                this.monitor.add(this);
            }
            if (this.runnable != null) {
                this.run();
            } else {
                this.call();
            }
            Event event = this;
            synchronized (event) {
                this.done = true;
                this.thread = null;
                this.notifyAll();
            }
        }

        void run() {
            block2: {
                try {
                    this.runnable.run();
                    this.handler.callback(null);
                }
                catch (Exception ex) {
                    if (this.handler.exception(ex)) break block2;
                    this.exception = ex;
                }
            }
        }

        void call() {
            block2: {
                try {
                    V ret = this.callable.call();
                    this.returnValue = ret;
                    this.handler.callback(ret);
                }
                catch (Exception ex) {
                    if (this.handler.exception(ex)) break block2;
                    this.exception = ex;
                }
            }
        }
    }

    public static class CallableWait<V>
    extends Wait<V> {
        CallableWait(Event event) {
            super(event);
        }

        public V complete() {
            try {
                return this.complete(0L);
            }
            catch (TimeoutException e) {
                return null;
            }
        }

        public V complete(long timeout) throws TimeoutException {
            this.await(timeout);
            return (V)this.event.returnValue;
        }
    }

    public static class RunnableWait
    extends Wait<Void> {
        RunnableWait(Event event) {
            super(event);
        }

        public void complete() {
            try {
                this.await(0L);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }

        public void complete(long timeout) throws TimeoutException {
            this.await(timeout);
        }
    }

    public static class Wait<V> {
        Event event;

        Wait(Event event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void await(long timeout) throws TimeoutException {
            long start = System.currentTimeMillis();
            boolean first = true;
            Event event = this.event;
            synchronized (event) {
                while (!this.event.done) {
                    try {
                        if (timeout <= 0L) {
                            this.event.wait();
                        } else {
                            long wait;
                            if (!first && System.currentTimeMillis() - start > timeout) {
                                throw new TimeoutException();
                            }
                            if (first) {
                                first = false;
                            }
                            if ((wait = timeout - (System.currentTimeMillis() - start)) > 0L) {
                                this.event.wait(wait);
                            }
                        }
                        if (this.event.exception == null) continue;
                        throw new SystemException(this.event.exception);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new SystemException(e);
                    }
                }
            }
        }
    }
}

