/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util;

import groovy.lang.Closure;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.util.SystemException;

public class TextSubstitution {
    private static DefaultScriptable defaultScriptable = new DefaultScriptable();
    private Map<String, Var> variables;
    private String template;
    private Scriptable script = defaultScriptable;

    public TextSubstitution(String template) {
        this.template = template;
        this.variables = this.parseVariableNames(template);
    }

    public TextSubstitution(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[4096];
        int len = 0;
        while ((len = reader.read(buffer)) >= 0) {
            builder.append(buffer, 0, len);
        }
        this.template = builder.toString();
        this.variables = this.parseVariableNames(this.template);
        reader.close();
    }

    public static DefaultScriptable defaultScriptable() {
        return defaultScriptable;
    }

    public String getTemplate() {
        return this.template;
    }

    public TextSubstitution withScriptable(Scriptable script) {
        this.script = script;
        return this;
    }

    public String build(Object binding) {
        return this.build(binding, Collections.emptyMap());
    }

    public String build(Object binding, Map<String, Object> auxillary) {
        if (this.template == null) {
            return "";
        }
        String text = this.template;
        for (Map.Entry<String, Var> entry : this.variables.entrySet()) {
            Var var = entry.getValue();
            text = this.replaceVariable(entry.getKey(), var.build(binding, auxillary), text);
        }
        text = text.replace("\\$", "$");
        return text;
    }

    private String replaceVariable(String key, String value, String text) {
        return text.replace("${" + key + "}", value);
    }

    private void parse(String text, List<Var> varList) {
        int max = text.length();
        int pos = 0;
        int prev = -1;
        while (pos < max - 1) {
            if (pos > 0) {
                prev = text.codePointAt(pos - 1);
            }
            if (prev != 92 && text.codePointAt(pos) == 36 && text.codePointAt(pos + 1) == 123) {
                int start = pos + 2;
                Var var = this.parseVar(text, start);
                varList.add(var);
                pos = start + var.text.length() + 1;
                continue;
            }
            ++pos;
        }
    }

    private Var parseVar(String text, int pos) {
        int max = text.length();
        String key = null;
        String strategy = null;
        int cursor = pos;
        int strategyIndex = -1;
        int prev = -1;
        while (cursor < max) {
            if (cursor > pos) {
                prev = text.codePointAt(cursor - 1);
            }
            if (prev != 92 && text.codePointAt(cursor) == 36 && cursor < max - 1 && text.codePointAt(cursor + 1) == 123) {
                cursor = TextSubstitution.skipNested(text, cursor + 2);
                continue;
            }
            if (text.codePointAt(cursor) == 125) {
                return this.newVar(text.substring(pos, cursor), key, strategy, strategyIndex >= 0 ? text.substring(strategyIndex, cursor) : "");
            }
            if (strategy == null && text.codePointAt(cursor) == 58 && cursor < max - 1 && text.codePointAt(cursor + 1) == 43) {
                key = text.substring(pos, cursor);
                strategy = ":+";
                strategyIndex = cursor + 2;
                cursor += 2;
                continue;
            }
            if (strategy == null && text.codePointAt(cursor) == 58 && cursor < max - 1 && text.codePointAt(cursor + 1) == 45) {
                key = text.substring(pos, cursor);
                strategy = ":-";
                strategyIndex = cursor + 2;
                cursor += 2;
                continue;
            }
            if (strategy == null && text.codePointAt(cursor) == 58 && cursor < max - 1 && text.codePointAt(cursor + 1) == 61) {
                key = text.substring(pos, cursor);
                strategy = ":=";
                strategyIndex = cursor + 2;
                cursor += 2;
                continue;
            }
            if (strategy == null && text.codePointAt(cursor) == 58 && cursor < max - 1 && text.codePointAt(cursor + 1) == 94) {
                key = text.substring(pos, cursor);
                strategy = ":^";
                strategyIndex = cursor + 2;
                cursor += 2;
                continue;
            }
            if (strategy == null && text.codePointAt(cursor) == 58 && cursor < max - 1 && text.codePointAt(cursor + 1) == 58) {
                key = text.substring(pos, cursor);
                strategy = ":";
                strategyIndex = cursor + 2;
                cursor += 2;
                continue;
            }
            if (strategy == null && text.codePointAt(cursor) == 58) {
                key = text.substring(pos, cursor);
                strategy = ":";
                strategyIndex = cursor + 1;
                ++cursor;
                continue;
            }
            ++cursor;
        }
        return this.newVar(text.substring(pos, max), key, strategy, strategyIndex >= 0 ? text.substring(strategyIndex, max) : "");
    }

    private Var newVar(String text, String key, String strategy, String defaultValue) {
        Var variable = new Var(text, key == null ? text : key);
        variable.strategy = strategy;
        variable.defaultValue = defaultValue;
        return variable;
    }

    private static int skipNested(String text, int pos) {
        int max = text.length();
        int cursor = pos;
        while (cursor < max) {
            if (text.codePointAt(cursor) == 36 && cursor < max - 1 && text.codePointAt(cursor + 1) == 123) {
                cursor = TextSubstitution.skipNested(text, cursor + 2);
                continue;
            }
            if (text.codePointAt(cursor) == 125) {
                return cursor + 1;
            }
            ++cursor;
        }
        return max;
    }

    private Map<String, Var> parseVariableNames(String text) {
        LinkedHashMap<String, Var> vars = new LinkedHashMap<String, Var>();
        LinkedList<Var> varList = new LinkedList<Var>();
        this.parse(text, varList);
        for (Var v : varList) {
            vars.put(v.text, v);
        }
        return vars;
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    public static class DefaultScriptable
    implements Scriptable {
        private ResourceManager resourceManager = new ResourceManager();

        public synchronized ResourceManager getResourceManager() {
            return this.resourceManager;
        }

        public synchronized void setResourceManager(ResourceManager resourceManager) {
            this.resourceManager = resourceManager;
        }

        @Override
        public String eval(Object result, String value) {
            Closure closure = (Closure)this.resourceManager.getScripting().eval("{ it ->" + value + " }", true);
            return "" + (String)closure.call(result);
        }
    }

    @FunctionalInterface
    public static interface Scriptable {
        public String eval(Object var1, String var2);
    }

    private class Var {
        String text;
        String key;
        String strategy;
        String defaultValue;
        private String leading;
        private String trailing;
        private String[] path;

        Var(String text, String key) {
            int i;
            this.text = text;
            this.key = key;
            int index = 0;
            for (i = 0; i < key.length(); ++i) {
                if (Character.isWhitespace(key.codePointAt(i))) continue;
                index = i;
                break;
            }
            this.leading = key.substring(0, index);
            index = key.length();
            for (i = key.length() - 1; i >= 0; --i) {
                if (Character.isWhitespace(key.codePointAt(i))) continue;
                index = i + 1;
                break;
            }
            this.trailing = "";
            if (index < key.length()) {
                this.trailing = key.substring(index);
            }
            this.path = key.split("\\.");
        }

        String build(Object object, Map<String, Object> auxillary) {
            String value;
            String[] components = this.path;
            if (this.key.contains("${")) {
                components = new TextSubstitution(this.key).build(object, auxillary).split("\\.");
            }
            Object result = object;
            for (String comp : components) {
                if ((comp = comp.trim()).isEmpty()) {
                    result = null;
                    continue;
                }
                try {
                    if (result == null) break;
                    if (result instanceof Map) {
                        if ((result = ((Map)result).get(comp)) != null) continue;
                        result = auxillary.get(comp);
                        continue;
                    }
                    try {
                        PropertyDescriptor desc = new PropertyDescriptor(comp, result.getClass(), "is" + TextSubstitution.capitalize(comp), null);
                        result = desc.getReadMethod().invoke(result, new Object[0]);
                    }
                    catch (IntrospectionException ex) {
                        Logger.suppress(ex);
                        result = null;
                    }
                    if (result != null) continue;
                    result = auxillary.get(comp);
                }
                catch (Exception e) {
                    Logger.suppress(e);
                    throw new SystemException(e);
                }
            }
            if ((value = this.defaultValue).contains("${")) {
                value = new TextSubstitution(this.defaultValue).build(object, auxillary);
            }
            if (result == null) {
                if (":+".equals(this.strategy)) {
                    return "";
                }
                if (":-".equals(this.strategy)) {
                    return value;
                }
                if (":=".equals(this.strategy)) {
                    return this.ternary(null, value);
                }
                if (":^".equals(this.strategy)) {
                    return this.scripting(result, value);
                }
                if (":".equals(this.strategy)) {
                    return value;
                }
                return "";
            }
            if (":+".equals(this.strategy)) {
                return value;
            }
            if (":-".equals(this.strategy)) {
                return "";
            }
            if (":=".equals(this.strategy)) {
                return this.ternary(result.toString(), value);
            }
            if (":^".equals(this.strategy)) {
                return this.scripting(result, value);
            }
            if (":".equals(this.strategy)) {
                return this.leading + result.toString() + this.trailing;
            }
            return this.leading + result.toString() + this.trailing;
        }

        private String ternary(String result, String value) {
            int p = value.indexOf(63);
            if (p < 0) {
                throw new SystemException("Invalid := expression, missing '?'");
            }
            String predicate = value.substring(0, p).trim();
            int c = value.indexOf(58, p);
            if (c < 0) {
                throw new SystemException("Invalid := expression, missing ':' after '?'");
            }
            String match = value.substring(p + 1, c);
            String not = value.substring(c + 1);
            if (result != null && result.equals(predicate)) {
                return match;
            }
            return not;
        }

        private String scripting(Object result, String value) {
            if (TextSubstitution.this.script == null) {
                return "";
            }
            return TextSubstitution.this.script.eval(result, value);
        }
    }
}

