/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util;

import java.util.Arrays;

public class StringUtil {
    private StringUtil() {
    }

    public static boolean isNullOrEmpty(String p) {
        return p == null || p.trim().isEmpty();
    }

    public static String padLeft(String content, int width, char padding) {
        return StringUtil.pad(content, width, padding, false);
    }

    public static String padRight(String content, int width, char padding) {
        return StringUtil.pad(content, width, padding, true);
    }

    public static String pad(String content, int width, char padding, boolean leftAligned) {
        int diff;
        String str = "";
        if (content != null) {
            str = content;
        }
        if ((diff = width - str.length()) <= 0) {
            return str;
        }
        char[] chars = new char[diff];
        Arrays.fill(chars, padding);
        if (leftAligned) {
            return str + new String(chars);
        }
        return new String(chars) + str;
    }

    public static String trim(String s) {
        int start;
        if (s == null) {
            return null;
        }
        int end = s.length() - 1;
        for (start = 0; start <= end && Character.isWhitespace(s.charAt(start)); ++start) {
        }
        while (end > start && Character.isWhitespace(s.charAt(end))) {
            --end;
        }
        return s.substring(start, end + 1);
    }

    public static boolean isNotBlank(String str) {
        return !StringUtil.isBlank(str);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

