/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.ObjectConverter;
import net.e6tech.elements.common.reflection.Primitives;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.util.SystemException;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class Configuration
extends LinkedHashMap<String, Object> {
    private static Logger logger = Logger.getLogger();
    private static final String NO_SUCH_PROPERTY = ": No such property ";
    private static final String BEGIN = "${";
    private static final String END = "}";
    private static final YamlConstructor yamlConstructor = new YamlConstructor();
    private Properties properties = new Properties();
    private Map<String, List<Reference>> references = new HashMap<String, List<Reference>>();

    public Configuration() {
    }

    public Configuration(Properties properties) {
        if (properties != null) {
            this.properties = properties;
        }
    }

    public static Map<String, List<String>> defineEnvironments(String str) {
        Yaml yaml = new Yaml((BaseConstructor)new YamlConstructor());
        return (Map)yaml.load(str);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Configuration)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public static Yaml newYaml() {
        return new Yaml((BaseConstructor)yamlConstructor);
    }

    public Configuration loadFile(String file) throws IOException {
        Path path = FileSystems.getDefault().getPath(file, new String[0]);
        try (BufferedReader reader = Files.newBufferedReader(path);){
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\n");
            }
            Configuration configuration = this.load(builder.toString());
            return configuration;
        }
    }

    public Configuration load(Configuration config) {
        this.properties.putAll((Map<?, ?>)config.properties);
        this.merge(this, config);
        for (Map.Entry<String, List<Reference>> entry : config.references.entrySet()) {
            List current = this.references.computeIfAbsent(entry.getKey(), k -> new ArrayList());
            current.addAll((Collection)entry.getValue());
        }
        return this;
    }

    public Configuration load(String configStr) {
        String text = configStr;
        Yaml yaml = Configuration.newYaml();
        if (text.contains(BEGIN)) {
            text = this.parse(text, true);
        }
        Iterable iterable = yaml.loadAll(text);
        this.loadYaml(iterable);
        this.references.clear();
        this.reformatMap("", this, this.references);
        return this;
    }

    private void loadYaml(Iterable<Object> iterable) {
        LinkedList<Map> maps = new LinkedList<Map>();
        for (Object obj : iterable) {
            if (obj instanceof Map) {
                maps.add((Map)obj);
                continue;
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(obj.toString(), null);
            maps.add(map);
        }
        for (Map map : maps) {
            if (map == null) continue;
            this.merge(this, map);
        }
    }

    private void merge(Map<String, Object> map1, Map<String, Object> map2) {
        for (Map.Entry<String, Object> entry : map2.entrySet()) {
            if (map1.get(entry.getKey()) != null) {
                Object existing = map1.get(entry.getKey());
                if (existing instanceof Map && entry.getValue() instanceof Map) {
                    this.merge((Map)existing, (Map)entry.getValue());
                    continue;
                }
                map1.put(entry.getKey(), entry.getValue());
                continue;
            }
            map1.put(entry.getKey(), entry.getValue());
        }
    }

    public Path dump(String file) throws IOException {
        LinkedHashMap map = new LinkedHashMap();
        for (String key : this.keySet()) {
            map.put(key, this.get(key));
        }
        Yaml yaml = new Yaml();
        Path path = Paths.get(file, new String[0]);
        yaml.dump(map, (Writer)Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]));
        return path;
    }

    public <T> T get(String key) {
        Object object = super.get(key);
        if (object instanceof String) {
            String value = (String)object;
            if (value.contains(BEGIN)) {
                Yaml yaml = Configuration.newYaml();
                value = this.parse(value, false);
                Map map = (Map)yaml.load(key + ": " + value);
                this.put(key, map.get(key));
                return (T)map.get(key);
            }
            return (T)object;
        }
        return (T)object;
    }

    private String parse(String valueStr, boolean useProperties) {
        String value = valueStr;
        int start = value.indexOf(BEGIN);
        if (start >= 0) {
            boolean loop = true;
            while (loop) {
                String substring;
                int end = value.indexOf(END, start + BEGIN.length());
                if (end < 0) {
                    loop = false;
                    continue;
                }
                int nested = value.indexOf(BEGIN, start + BEGIN.length());
                if (nested < end && nested >= 0) {
                    substring = this.parse(value.substring(nested), useProperties);
                    if (substring.startsWith(BEGIN)) {
                        int lineTerm = substring.indexOf(10);
                        String line = substring;
                        if (lineTerm > 0) {
                            line = substring.substring(0, lineTerm);
                        }
                        int begin = BEGIN.length();
                        int count = 2;
                        int matchingEnd = 0;
                        while (count > 0) {
                            int nextEnd = line.indexOf(END, begin);
                            int nextBegin = line.indexOf(BEGIN, begin);
                            if (nextEnd < 0) {
                                matchingEnd = line.length();
                                continue;
                            }
                            if (nextBegin > 0 && nextBegin < nextEnd) {
                                begin = nextBegin + BEGIN.length();
                                ++count;
                                continue;
                            }
                            --count;
                            matchingEnd = nextEnd;
                        }
                        start += matchingEnd;
                    }
                    value = value.substring(0, nested) + substring;
                    loop = true;
                    continue;
                }
                substring = value.substring(start + BEGIN.length(), end);
                String remain = end + END.length() == value.length() ? "" : value.substring(end + END.length());
                value = value.substring(0, start) + this.resolve(substring, useProperties) + remain;
                start = value.indexOf(BEGIN, start + BEGIN.length());
                loop = start >= 0;
            }
        }
        return value;
    }

    private String resolve(String value, boolean useProperties) {
        String obj;
        String string = obj = useProperties ? this.properties.getProperty(value.trim()) : super.get(value.trim()).toString();
        if (obj == null) {
            return BEGIN + value + END;
        }
        return obj;
    }

    public void configure(Object object) {
        this.configure(object, null, null, null);
    }

    public void configure(Object object, String prefixArg, Resolver resolver, ObjectConverter.InstanceCreationListener listener) {
        this.configure(new ObjectConverter(resolver, listener), object, prefixArg);
    }

    public void configure(ObjectConverter converter, Object object, String prefixArg) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        String prefix = prefixArg;
        try {
            Object value;
            if (this.get(prefix) instanceof Map && !(object instanceof Map)) {
                this.configureWithMap(converter, object, (Map)this.get(prefix));
            }
            if (prefix != null) {
                prefix = prefix.trim();
            }
            if (prefix != null && !prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            if (prefix == null || ".".equals(prefix)) {
                prefix = "";
            }
            if (object instanceof Map) {
                List<Reference> referenceList;
                Map map = (Map)object;
                for (Object key : this.keySet()) {
                    if ("".equals(prefix) || ((String)key).startsWith(prefix)) {
                        String subkey = ((String)key).substring(prefix.length());
                        if (object instanceof Properties) {
                            map.put(subkey, this.get((String)key).toString());
                            continue;
                        }
                        map.put(subkey, this.get((String)key));
                        continue;
                    }
                    if (!((String)key).equals(prefixArg) || !(this.get(prefixArg) instanceof Map)) continue;
                    Map val = (Map)this.get(prefixArg);
                    val.forEach((k, v) -> {
                        if (converter.getResolver() != null && v instanceof String && v.toString().startsWith("^")) {
                            map.put(k, converter.getResolver().resolve(v.toString()));
                        } else {
                            map.put(k, v);
                        }
                    });
                }
                if (converter.getResolver() != null && (referenceList = this.references.get(prefixArg)) != null) {
                    for (Reference reference : referenceList) {
                        map.put(reference.key, converter.getResolver().resolve(reference.lookup));
                    }
                }
                return;
            }
            BeanInfo info = Introspector.getBeanInfo(object.getClass());
            LinkedHashMap<String, PropertyDescriptor> setters = new LinkedHashMap<String, PropertyDescriptor>();
            LinkedHashMap<String, PropertyDescriptor> getters = new LinkedHashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor desc : info.getPropertyDescriptors()) {
                String key;
                if (desc.getWriteMethod() != null && (value = this.get(key = prefix + desc.getName())) != null) {
                    setters.put(key, desc);
                }
                if (desc.getReadMethod() == null) continue;
                key = prefix + desc.getName();
                getters.put(key, desc);
            }
            HashSet<String> applicableKeys = new HashSet<String>();
            for (String key : this.keySet()) {
                int index;
                if (!key.startsWith(prefix) || (index = key.indexOf(46, prefix.length())) >= 0) continue;
                applicableKeys.add(key);
            }
            HashSet configured = new HashSet();
            for (Map.Entry entry : setters.entrySet()) {
                PropertyDescriptor desc = (PropertyDescriptor)entry.getValue();
                value = this.get((String)entry.getKey());
                if (!Map.class.isAssignableFrom(desc.getPropertyType()) && value instanceof Map && desc.getReadMethod() != null && desc.getReadMethod().invoke(object, new Object[0]) != null) {
                    applicableKeys.remove(entry.getKey());
                    continue;
                }
                this.setValueForOwner(converter, object, desc, value);
                applicableKeys.remove(entry.getKey());
                configured.add(entry.getKey());
            }
            if (!applicableKeys.isEmpty()) {
                logger.warn("object {} does not have properties: {}", object.getClass(), applicableKeys);
            }
            for (String key : this.keySet()) {
                PropertyDescriptor desc;
                String fieldKey;
                if (configured.contains(key) || !"".equals(prefix) && !key.startsWith(prefix)) continue;
                boolean shouldRecurse = true;
                String subkey = key.substring(prefix.length());
                if (subkey.contains(".")) {
                    fieldKey = subkey.substring(0, subkey.indexOf(46));
                } else {
                    fieldKey = subkey;
                    Object val = this.get(key);
                    if (!(val instanceof Map)) {
                        shouldRecurse = false;
                    }
                }
                if ((desc = (PropertyDescriptor)getters.get(prefix + fieldKey)) == null || desc.getReadMethod() == null) continue;
                LinkedHashMap val = desc.getReadMethod().invoke(object, new Object[0]);
                if (!shouldRecurse) continue;
                Class<?> fieldClass = desc.getReadMethod().getReturnType();
                if (val == null && Map.class.isAssignableFrom(fieldClass) && desc.getWriteMethod() != null) {
                    if (Properties.class.isAssignableFrom(fieldClass)) {
                        val = new Properties();
                    } else {
                        try {
                            val = fieldClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Exception th) {
                            Logger.suppress(th);
                            val = new LinkedHashMap();
                        }
                    }
                    try {
                        desc.getWriteMethod().invoke(object, val);
                    }
                    catch (Exception th) {
                        Logger.suppress(th);
                        val = null;
                    }
                }
                if (val == null) continue;
                this.configure(converter, val, prefix + fieldKey);
            }
            this.resolveReferences(object, prefix, (Resolver)converter.getResolver());
        }
        catch (Exception e) {
            throw logger.systemException(e);
        }
    }

    private void resolveReferences(Object object, String prefixArg, Resolver resolver) {
        block11: {
            if (object == null) {
                throw new IllegalArgumentException();
            }
            String prefix = prefixArg;
            try {
                if (prefix != null) {
                    prefix = prefix.trim();
                }
                if (prefix != null && !prefix.endsWith(".")) {
                    prefix = prefix + ".";
                }
                if (prefix == null || ".".equals(prefix)) {
                    prefix = "";
                }
                if (resolver == null) break block11;
                String substitutionObjectKey = prefix;
                while (substitutionObjectKey.endsWith(".")) {
                    substitutionObjectKey = substitutionObjectKey.substring(0, substitutionObjectKey.length() - 1);
                }
                for (Map.Entry<String, List<Reference>> entry : this.references.entrySet()) {
                    Object val;
                    String subkey;
                    String fieldKey;
                    PropertyDescriptor desc;
                    if (entry.getKey().equals(substitutionObjectKey)) {
                        List<Reference> referenceList = entry.getValue();
                        for (Reference reference : referenceList) {
                            if (object instanceof Map) {
                                ((Map)object).put(reference.key, resolver.resolve(reference.lookup));
                                continue;
                            }
                            PropertyDescriptor desc2 = new PropertyDescriptor(reference.key, object.getClass());
                            if (desc2 == null || desc2.getWriteMethod() == null) continue;
                            desc2.getWriteMethod().invoke(object, resolver.resolve(reference.lookup));
                        }
                        continue;
                    }
                    if (!entry.getKey().contains(prefix) || (desc = new PropertyDescriptor(fieldKey = (subkey = entry.getKey().substring(prefix.length())).contains(".") ? subkey.substring(0, subkey.indexOf(46)) : subkey, object.getClass())) == null || desc.getReadMethod() == null || (val = desc.getReadMethod().invoke(object, new Object[0])) == null) continue;
                    this.resolveReferences(val, prefix + fieldKey, resolver);
                }
            }
            catch (Exception e) {
                throw logger.systemException(e);
            }
        }
    }

    public void configureWithMap(Object object, Map<String, Object> map, Resolver resolver, ObjectConverter.InstanceCreationListener listener) {
        this.configureWithMap(new ObjectConverter(resolver, listener), object, map);
    }

    protected void configureWithMap(ObjectConverter converter, Object object, Map<String, Object> map) {
        HashSet<String> applicableKeys = new HashSet<String>();
        applicableKeys.addAll(map.keySet());
        try {
            BeanInfo info = Introspector.getBeanInfo(object.getClass());
            for (PropertyDescriptor desc : info.getPropertyDescriptors()) {
                if (desc.getWriteMethod() == null || !map.containsKey(desc.getName())) continue;
                Object val = map.get(desc.getName());
                this.setValueForOwner(converter, object, desc, val);
                applicableKeys.remove(desc.getName());
            }
            Iterator iterator = applicableKeys.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                if (!key.contains(".")) continue;
                String[] path = key.split("\\.");
                Object obj = null;
                try {
                    if (path[0].trim().length() > 0) {
                        obj = Reflection.getProperty(object, path[0]);
                    }
                }
                catch (Exception ex) {
                    throw new SystemException(object.getClass().getName() + "." + key + NO_SUCH_PROPERTY + path[0], ex);
                }
                for (int i = 1; i < path.length - 1 && obj != null; ++i) {
                    try {
                        obj = Reflection.getProperty(obj, path[i].trim());
                        continue;
                    }
                    catch (Exception ex) {
                        throw new SystemException(object.getClass().getName() + "." + key + NO_SUCH_PROPERTY + path[i], ex);
                    }
                }
                if (obj == null) continue;
                try {
                    PropertyDescriptor desc = new PropertyDescriptor(path[path.length - 1], obj.getClass());
                    if (desc.getWriteMethod() == null) break;
                    Object val = map.get(key);
                    this.setValueForOwner(converter, obj, desc, val);
                    iterator.remove();
                }
                catch (IntrospectionException ex) {
                    throw new SystemException(object.getClass().getName() + "." + key + NO_SUCH_PROPERTY + path[path.length - 1], ex);
                }
            }
            if (!applicableKeys.isEmpty()) {
                logger.warn("object {} does not have properties: {}", object.getClass().getName(), applicableKeys);
            }
        }
        catch (Exception e) {
            throw logger.systemException(e);
        }
    }

    private void setValueForOwner(ObjectConverter converter, Object owner, PropertyDescriptor desc, Object val) throws IOException, InvocationTargetException, IllegalAccessException {
        Object curr;
        Method method = desc.getWriteMethod() != null ? desc.getWriteMethod() : desc.getReadMethod();
        Object value = null;
        if (desc.getReadMethod() != null && (curr = desc.getReadMethod().invoke(owner, new Object[0])) != null) {
            if (val instanceof Map && !(curr instanceof Map)) {
                this.configureWithMap(converter, curr, (Map)val);
                return;
            }
            value = converter.convert(val, desc.getReadMethod());
        }
        if (value == null) {
            value = converter.convert(val, method);
        }
        if (converter.getListener() != null && val != null) {
            converter.getListener().instanceCreated(value, desc.getPropertyType(), value);
        }
        try {
            if (Primitives.isPrimitive(desc.getPropertyType()) && value == null) {
                value = Primitives.defaultValue(desc.getPropertyType());
            }
            desc.getWriteMethod().invoke(owner, value);
        }
        catch (IllegalArgumentException ex) {
            throw new SystemException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reformatMap(String prefixArg, Map<String, Object> map, Map<String, List<Reference>> substitutions) {
        String prefix = prefixArg;
        if (prefix != null) {
            prefix = prefix.trim();
        }
        if (prefix == null) {
            prefix = "";
        }
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof String) {
                String entryKey = entry.getKey();
                String value = ((String)entry.getValue()).trim();
                if (!value.startsWith("^")) continue;
                String lookup = value.substring(1).trim();
                Reference reference = new Reference(entry.getKey(), lookup);
                List referenceList = null;
                if ("".equals(prefix)) {
                    if (!entryKey.contains(".")) throw new IllegalArgumentException("top level key cannot use '^' reference.");
                    int lastIndex = entryKey.lastIndexOf(46);
                    String owner = entryKey.substring(0, lastIndex);
                    String key = entryKey.substring(lastIndex + 1);
                    reference = new Reference(key, lookup);
                    referenceList = substitutions.computeIfAbsent(owner, k -> new ArrayList());
                } else {
                    referenceList = substitutions.computeIfAbsent(prefix, k -> new ArrayList());
                }
                referenceList.add(reference);
                toBeRemoved.add(entry.getKey());
                continue;
            }
            if (entry.getValue() instanceof Map) {
                StringBuilder builder = new StringBuilder();
                builder.append(prefix);
                if (!"".equals(prefix)) {
                    builder.append(".");
                }
                builder.append(entry.getKey());
                this.reformatMap(builder.toString(), (Map)entry.getValue(), substitutions);
                continue;
            }
            if (!(entry.getValue() instanceof Collection)) continue;
        }
        for (String key : toBeRemoved) {
            map.remove(key);
        }
    }

    @FunctionalInterface
    public static interface Resolver
    extends net.e6tech.elements.common.reflection.Resolver {
    }

    public static class YamlConstructor
    extends Constructor {
        public YamlConstructor() {
            super(new LoaderOptions());
            this.yamlConstructors.put(Tag.FLOAT, new BigDecimalConstructor());
            this.yamlConstructors.put(Tag.INT, new LongConstructor());
        }

        private class LongConstructor
        extends AbstractConstruct {
            private LongConstructor() {
            }

            public Object construct(Node node) {
                String value = YamlConstructor.this.constructScalar((ScalarNode)node).replaceAll("_", "");
                return Long.parseLong(value);
            }
        }

        private class BigDecimalConstructor
        extends AbstractConstruct {
            private BigDecimalConstructor() {
            }

            public Object construct(Node node) {
                String value = YamlConstructor.this.constructScalar((ScalarNode)node).replaceAll("_", "");
                int sign = 1;
                char first = value.charAt(0);
                if (first == '-') {
                    sign = -1;
                    value = value.substring(1);
                } else if (first == '+') {
                    value = value.substring(1);
                }
                BigDecimal decimal = new BigDecimal(value);
                if (sign > 0) {
                    return decimal;
                }
                return decimal.negate();
            }
        }
    }

    private static class Reference
    implements Serializable {
        String key;
        String lookup;

        Reference(String key, String lookup) {
            this.key = key;
            this.lookup = lookup;
        }
    }
}

