/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.notification;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import net.e6tech.elements.common.actor.GenesisActor;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.notification.Notification;
import net.e6tech.elements.common.notification.NotificationCenter;
import net.e6tech.elements.common.notification.NotificationListener;
import net.e6tech.elements.common.resources.Provision;

public class NotificationProcessor
implements NotificationListener {
    private ExecutorService threadPool;
    private GenesisActor genesis;
    private NotificationCenter notificationCenter;
    private Provision provision;
    private Map<Class<? extends Notification>, Method> methods = new HashMap<Class<? extends Notification>, Method>();
    private Class<? extends Notification>[] notificationTypes = new Class[0];

    public NotificationProcessor() {
        ArrayList types = new ArrayList();
        for (Class<?> cls = this.getClass(); cls != null && !cls.equals(Object.class); cls = cls.getSuperclass()) {
            Method[] methodArray;
            for (Method method : methodArray = cls.getDeclaredMethods()) {
                if (!"processEvent".equals(method.getName()) || method.getParameterCount() != 1 || !Notification.class.isAssignableFrom(method.getParameterTypes()[0])) continue;
                method.setAccessible(true);
                Class<?> notificationType = method.getParameterTypes()[0];
                this.methods.computeIfAbsent(notificationType, key -> {
                    types.add(notificationType);
                    return method;
                });
            }
        }
        this.notificationTypes = types.toArray(new Class[types.size()]);
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    @Inject(optional=true)
    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public GenesisActor getGenesis() {
        return this.genesis;
    }

    @Inject(optional=true)
    public void setGenesis(GenesisActor genesis) {
        this.genesis = genesis;
    }

    public NotificationCenter getNotificationCenter() {
        return this.notificationCenter;
    }

    @Inject
    public void setNotificationCenter(NotificationCenter notificationCenter) {
        this.notificationCenter = notificationCenter;
    }

    public Provision getProvision() {
        return this.provision;
    }

    @Inject
    public void setProvision(Provision provision) {
        this.provision = provision;
    }

    @Override
    public Class<? extends Notification>[] getNotificationTypes() {
        return this.notificationTypes;
    }

    public void onEvent(Notification notification) {
        Class<?> cls = notification.getClass();
        while (!cls.equals(Object.class)) {
            Method method = this.methods.get(cls);
            if (method != null) {
                try {
                    method.invoke((Object)this, notification);
                }
                catch (Exception e) {
                    Logger.suppress(e);
                }
                return;
            }
            cls = cls.getSuperclass();
        }
        this.catchEvent(notification);
    }

    public void catchEvent(Notification notification) {
    }

    public void async(Runnable runnable) {
        if (this.genesis != null) {
            this.genesis.async(runnable);
        } else if (this.threadPool != null) {
            this.threadPool.execute(runnable);
        } else {
            Thread thread = new Thread(runnable);
            thread.start();
        }
    }
}

