/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.e6tech.elements.common.reflection.Annotator;
import net.e6tech.elements.common.resources.Configurator;

public interface Configurable<U> {
    public Configurator configurator();

    public U configurable();

    default public U annotation(Class<? extends Annotation> key) {
        this.configurator().annotation(key);
        return this.configurable();
    }

    default public <T> T get(String key) {
        return this.configurator().get(key);
    }

    default public <T> T get(String key, T defval) {
        return this.configurator().get(key, defval);
    }

    default public <T> T get(Class<T> key) {
        return this.configurator().get(key);
    }

    default public <T> T get(Class<T> key, T defval) {
        return this.configurator().get(key);
    }

    default public <T> T computeIfAbsent(String key, Function<String, T> mappingFunction) {
        return this.configurator().computeIfAbsent(key, mappingFunction);
    }

    default public <T> T computeIfAbsent(Class<T> key, Function<Class<T>, T> mappingFunction) {
        return this.configurator().computeIfAbsent(key, mappingFunction);
    }

    default public <T extends Annotation> U annotate(Class<T> cls, BiConsumer<Annotator.AnnotationValue, T> consumer) {
        this.configurator().annotate(cls, consumer);
        return this.configurable();
    }

    default public <V, T extends Annotation> U annotate(Class<T> cls, Function<T, V> func, V value) {
        return this.annotate(cls, (annotationValue, annotation) -> annotationValue.set(() -> func.apply(annotation), value));
    }

    default public <T extends Annotation> ConfigurableAnnotator<U, T> annotate(Class<T> cls) {
        return new ConfigurableAnnotator(cls, this);
    }

    default public <T> U put(Class<T> cls, T instance) {
        this.configurator().put(cls, instance);
        return this.configurable();
    }

    default public U put(String key, Object value) {
        this.configurator().put(key, value);
        return this.configurable();
    }

    default public U putAll(Configurator configurator) {
        this.configurator().putAll(configurator);
        return this.configurable();
    }

    default public U putAll(Map map) {
        this.configurator().putAll(map);
        return this.configurable();
    }

    public static class ConfigurableAnnotator<U, T extends Annotation>
    implements Configurable<U> {
        Class<T> annotationClass;
        Configurable<U> configurable;

        ConfigurableAnnotator(Class<T> annotationClass, Configurable<U> configurable) {
            this.annotationClass = annotationClass;
            this.configurable = configurable;
        }

        @Override
        public Configurator configurator() {
            return this.configurable.configurator();
        }

        @Override
        public U configurable() {
            return this.configurable.configurable();
        }

        public <V> ConfigurableAnnotator<U, T> annotate(Function<T, V> func, V value) {
            this.annotate(this.annotationClass, func, value);
            return this;
        }
    }
}

