/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.reflection;

import java.lang.reflect.Method;
import net.e6tech.elements.common.reflection.Signature;

public class MethodSignature
extends Signature<Method> {
    private Class returnType;
    private Class<?>[] parameterTypes;
    private String signature;
    private Integer hashCode;

    public MethodSignature(Method method) {
        super(method.getName(), method);
        this.returnType = method.getReturnType();
        this.parameterTypes = method.getParameterTypes();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodSignature) {
            MethodSignature other = (MethodSignature)obj;
            if (this.getName().equals(other.getName())) {
                if (!this.returnType.equals(other.returnType)) {
                    return false;
                }
                return this.equalParamTypes(this.parameterTypes, other.parameterTypes);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.getName().hashCode() ^ this.returnType.hashCode();
        }
        return this.hashCode;
    }

    boolean equalParamTypes(Class<?>[] params1, Class<?>[] params2) {
        if (params1.length == params2.length) {
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.signature == null) {
            StringBuilder b = new StringBuilder(this.returnType.getName());
            b.append(' ').append(this.getName()).append('(');
            boolean first = true;
            for (Class<?> cls : this.parameterTypes) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append(cls.getName());
            }
            b.append(')');
            this.signature = b.toString();
        }
        return this.signature;
    }
}

