/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.SystemException;
import org.osjava.sj.memory.MemoryContext;

public class InitialContextFactory
implements javax.naming.spi.InitialContextFactory {
    static InheritableThreadLocal<Context> threadLocal = new InheritableThreadLocal();

    public static void setDefault() {
        System.setProperty("java.naming.factory.initial", InitialContextFactory.class.getName());
    }

    public Context getInitialContext(Hashtable environment) throws NamingException {
        Context ctx = (Context)threadLocal.get();
        if (ctx == null) {
            ctx = this.createContext(environment);
            threadLocal.set(ctx);
        }
        return ctx;
    }

    public Context createContext(Hashtable environment) {
        environment.put("jndi.syntax.direction", "left_to_right");
        environment.put("jndi.syntax.separator", "/");
        MemoryContext ctx = new MemoryContext(environment);
        return (Context)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Context.class}, (InvocationHandler)new ContextInvocationHandler((Context)ctx));
    }

    public static class ContextInvocationHandler
    implements InvocationHandler {
        Context ctx;
        List<Name> bound = new LinkedList<Name>();

        public ContextInvocationHandler(Context ctx) {
            this.ctx = ctx;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if ("bind".equals(methodName)) {
                Name name = null;
                if (args[0] instanceof String) {
                    name = this.ctx.getNameParser("").parse((String)args[0]);
                } else if (args[0] instanceof Name) {
                    name = (Name)args[0];
                } else {
                    throw new SystemException("Incompatible method argument[0]: expecting String of Name but got " + args[0]);
                }
                this.createContexts(name, this.ctx);
                this.bound.add(name);
                this.ctx.bind(name, args[1]);
            } else if ("rebind".equals(methodName)) {
                Name name = null;
                if (args[0] instanceof String) {
                    name = this.ctx.getNameParser("").parse((String)args[0]);
                } else if (args[0] instanceof Name) {
                    name = (Name)args[0];
                } else {
                    throw new SystemException("Incompatible method argument[0]: expecting String of Name but got " + args[0]);
                }
                this.createContexts(name, this.ctx);
                this.bound.add(name);
                this.ctx.rebind(name, args[1]);
            } else {
                if ("close".equals(methodName)) {
                    return null;
                }
                try {
                    return method.invoke((Object)this.ctx, args);
                }
                catch (InvocationTargetException e) {
                    Logger.suppress(e);
                    throw e.getTargetException();
                }
            }
            return null;
        }

        private Context createContexts(Name name, Context context) throws NamingException {
            Context subCtx = context;
            if (name.size() > 1) {
                Object object = subCtx.lookup(name.getPrefix(1));
                if (object instanceof Context) {
                    return this.createContexts(name.getSuffix(1), (Context)object);
                }
                if (object != null) {
                    throw new NamingException("already bound");
                }
                subCtx = subCtx.createSubcontext(name.getPrefix(1));
                return this.createContexts(name.getSuffix(1), subCtx);
            }
            return subCtx;
        }
    }
}

