/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.concurrent;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ThreadLocalMap<K, V>
implements Map<K, V> {
    private final ThreadLocal<Map<K, V>> threadLocal = new ThreadLocal();
    private final ThreadLocal<Object> lastUpdate = new ThreadLocal();
    private Map<K, V> map;
    private volatile Object dirty = new Object();

    public ThreadLocalMap() {
        this.map = new LinkedHashMap();
        this.threadLocal.set(this.map);
        this.lastUpdate.set(this.dirty);
    }

    public ThreadLocalMap(int initialCapacity) {
        this.map = new LinkedHashMap(initialCapacity);
        this.threadLocal.set(this.map);
        this.lastUpdate.set(this.dirty);
    }

    public ThreadLocalMap(Map<K, V> map) {
        this.map = map;
        this.threadLocal.set(map);
        this.lastUpdate.set(this.dirty);
    }

    public Object lastUpdate() {
        return this.lastUpdate.get();
    }

    public Map<K, V> merge() {
        return this.merge(this.dirty);
    }

    Map<K, V> merge(Object dirt) {
        Map<K, V> local = this.threadLocal.get();
        if (local == this.map) {
            this.lastUpdate.set(dirt);
            return this.map;
        }
        if (dirt == this.lastUpdate.get() && local != null) {
            return local;
        }
        int localSize = local != null ? local.size() : 0;
        LinkedHashMap<K, V> combined = new LinkedHashMap<K, V>(localSize + this.map.size() + 1);
        combined.putAll(this.map);
        if (local != null) {
            combined.putAll(local);
        }
        this.lastUpdate.set(dirt);
        this.threadLocal.set(combined);
        return combined;
    }

    public synchronized Map<K, V> mapThreadLocal() {
        if (this.threadLocal.get() == null) {
            this.threadLocal.set(new LinkedHashMap());
        }
        return this.threadLocal.get();
    }

    public boolean isDirty() {
        return this.dirty != this.lastUpdate.get();
    }

    @Override
    public synchronized int size() {
        return this.merge().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isEmpty() {
        Map<K, V> m = this.threadLocal.get();
        if (m != null && !m.isEmpty()) {
            return false;
        }
        ThreadLocalMap threadLocalMap = this;
        synchronized (threadLocalMap) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        Map<K, V> m = this.threadLocal.get();
        if (m != null && m.containsKey(key)) {
            return true;
        }
        ThreadLocalMap threadLocalMap = this;
        synchronized (threadLocalMap) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean containsValue(Object value) {
        Map<K, V> m = this.threadLocal.get();
        if (m != null && m.containsValue(value)) {
            return true;
        }
        ThreadLocalMap threadLocalMap = this;
        synchronized (threadLocalMap) {
            return this.map.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Map<K, V> m = this.threadLocal.get();
        if (m != null && m.containsKey(key)) {
            return m.get(key);
        }
        ThreadLocalMap threadLocalMap = this;
        synchronized (threadLocalMap) {
            return this.map.get(key);
        }
    }

    @Override
    public V put(K key, V value) {
        V old;
        Map<K, V> m = this.threadLocal.get();
        if (m == this.map) {
            return this.syncPut(key, value);
        }
        if (m != null) {
            if (m.containsKey(key)) {
                old = m.put(key, value);
                this.syncPut(key, value);
            } else {
                m.put(key, value);
                old = this.syncPut(key, value);
            }
        } else {
            m = new LinkedHashMap();
            this.threadLocal.set(m);
            m.put(key, value);
            old = this.syncPut(key, value);
        }
        return old;
    }

    private synchronized V syncPut(K key, V value) {
        boolean merged = this.dirty == this.lastUpdate.get();
        this.dirty = new Object();
        if (merged) {
            this.lastUpdate.set(this.dirty);
        }
        return this.map.put(key, value);
    }

    public V putThreadLocal(K key, V value) {
        V old;
        Map<K, V> m = this.threadLocal.get();
        if (m != null) {
            old = m.put(key, value);
        } else {
            m = new LinkedHashMap();
            this.threadLocal.set(m);
            old = m.put(key, value);
        }
        return old;
    }

    @Override
    public synchronized V remove(Object key) {
        this.dirty = new Object();
        Map<K, V> m = this.threadLocal.get();
        if (m == this.map) {
            return m.remove(key);
        }
        if (m != null) {
            this.map.remove(key);
            return m.remove(key);
        }
        return this.map.remove(key);
    }

    public V removeThreadLocal(K key) {
        Map<K, V> m = this.threadLocal.get();
        if (m != null) {
            return m.remove(key);
        }
        return null;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        this.dirty = new Object();
        Map<Object, Object> local = this.threadLocal.get();
        if (local == this.map) {
            local.putAll(m);
            return;
        }
        if (local != null) {
            local.putAll(m);
        }
        this.map.putAll(m);
    }

    @Override
    public synchronized void clear() {
        this.dirty = new Object();
        Map<K, V> local = this.threadLocal.get();
        if (local != this.map) {
            this.threadLocal.remove();
        }
        this.lastUpdate.set(this.dirty);
        this.map.clear();
    }

    @Override
    public synchronized Set<K> keySet() {
        return this.merge().keySet();
    }

    @Override
    public synchronized Collection<V> values() {
        return this.merge().values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Map<K, V> m = this.threadLocal.get();
        if (m == this.map) {
            return this.map.entrySet();
        }
        LinkedHashMap<K, TLEntry<K, V>> entries = new LinkedHashMap<K, TLEntry<K, V>>(2 * this.map.size() + 1);
        if (m != null) {
            for (Map.Entry entry : m.entrySet()) {
                entries.put(entry.getKey(), new TLEntry(entry, null));
            }
        }
        ThreadLocalMap threadLocalMap = this;
        synchronized (threadLocalMap) {
            for (Map.Entry<K, V> e : this.map.entrySet()) {
                TLEntry entry = (TLEntry)entries.get(e.getKey());
                if (entry != null) {
                    entry.global = e;
                    continue;
                }
                entries.put(e.getKey(), new TLEntry<K, V>(null, e));
            }
        }
        return new HashSet<Map.Entry<K, V>>(entries.values());
    }

    public synchronized void clearThreadLocal() {
        this.dirty = new Object();
        Map<K, V> local = this.threadLocal.get();
        if (local == this.map) {
            this.clear();
            return;
        }
        this.threadLocal.remove();
        this.lastUpdate.set(this.dirty);
    }

    class TLEntry<K, V>
    implements Map.Entry<K, V> {
        Map.Entry<K, V> local;
        Map.Entry<K, V> global;

        TLEntry(Map.Entry<K, V> local, Map.Entry<K, V> global) {
            this.local = local;
            this.global = global;
        }

        @Override
        public K getKey() {
            if (this.local != null) {
                return this.local.getKey();
            }
            return this.global.getKey();
        }

        @Override
        public V getValue() {
            if (this.local != null) {
                return this.local.getValue();
            }
            return this.global.getValue();
        }

        @Override
        public V setValue(V value) {
            ThreadLocalMap.this.dirty = new Object();
            V old = null;
            if (this.local != null) {
                old = this.local.setValue(value);
                if (this.global != null) {
                    this.global.setValue(value);
                }
            } else if (this.global != null) {
                old = this.global.setValue(value);
            }
            return old;
        }

        @Override
        public boolean equals(Object o) {
            if (this.local != null) {
                return this.local.equals(o);
            }
            if (this.global != null) {
                return this.global.equals(o);
            }
            return false;
        }

        @Override
        public int hashCode() {
            if (this.local != null) {
                return this.local.hashCode();
            }
            if (this.global != null) {
                return this.global.hashCode();
            }
            return 0;
        }
    }
}

