/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources.plugin;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.e6tech.elements.common.resources.plugin.Plugin;

public class PluginPath<T> {
    PluginPath parent;
    private Class<T> type;
    private String name;
    private String toString;
    private int hash = 0;
    private LinkedList<PluginPath> path;

    protected PluginPath(Class<T> cls, String name) {
        this.type = cls;
        this.name = name;
    }

    public static <T> PluginPath<T> of(Class<T> cls) {
        return new PluginPath<T>(cls, null);
    }

    public static <T> PluginPath<T> of(Class<T> cls, String name) {
        return new PluginPath<T>(cls, name);
    }

    public static PluginPath from(ClassLoader loader, String str) throws ClassNotFoundException {
        String[] strings = str.split("/");
        PluginPath<?> path = null;
        for (int i = 0; i < strings.length; i += 2) {
            String name = null;
            if (i + 1 < strings.length) {
                name = strings[i + 1];
            }
            path = path == null ? PluginPath.of(loader.loadClass(strings[i]), name) : path.and(loader.loadClass(strings[i]), name);
        }
        return path;
    }

    public static PluginPath from(String str) throws ClassNotFoundException {
        return PluginPath.from(PluginPath.class.getClassLoader(), str);
    }

    public PluginPath parent() {
        return this.parent;
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> type) {
        this.type = type;
        this.toString = null;
        this.hash = 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.toString = null;
        this.hash = 0;
    }

    public <R> PluginPath<R> and(Class<R> cls, String name) {
        PluginPath<R> child = new PluginPath<R>(cls, name);
        child.parent = this;
        return child;
    }

    public <R> PluginPath<R> and(Class<R> cls) {
        PluginPath<R> child = new PluginPath<R>(cls, null);
        child.parent = this;
        return child;
    }

    public <R> PluginPath<R> concat(PluginPath<R> rear) {
        List<PluginPath> list = rear.list();
        PluginPath<T> node = this.copy();
        for (PluginPath p : list) {
            node = node.and(p.getType(), p.getName());
        }
        return node;
    }

    public PluginPath<T> copy() {
        List<PluginPath> list = this.list();
        PluginPath<T> node = null;
        for (PluginPath p : list) {
            if (node == null) {
                node = new PluginPath<T>(p.getType(), p.getName());
                continue;
            }
            node = node.and(p.getType(), p.getName());
        }
        return node;
    }

    public synchronized List<PluginPath> list() {
        if (this.path != null) {
            return this.path;
        }
        this.path = new LinkedList();
        PluginPath p = this;
        while (p != null) {
            this.path.addFirst(p);
            p = p.parent;
        }
        return this.path;
    }

    public <P extends Plugin> PluginPath<P> changeRoot(Class rootClass, String rootName) {
        List<PluginPath> list = this.list();
        PluginPath<T> newPath = PluginPath.of(rootClass, rootName);
        for (int i = 1; i < list.size(); ++i) {
            PluginPath p = list.get(i);
            newPath = newPath.and(p.getType(), p.getName());
        }
        return newPath;
    }

    public <R> PluginPath<R> trimRoot() {
        List<PluginPath> list = this.list();
        PluginPath<T> sub = null;
        for (int i = 1; i < list.size(); ++i) {
            PluginPath p = list.get(i);
            sub = sub == null ? PluginPath.of(p.getType(), p.getName()) : sub.and(p.getType(), p.getName());
        }
        return sub;
    }

    public String path() {
        if (this.toString != null) {
            return this.toString;
        }
        StringBuilder builder = new StringBuilder();
        List<PluginPath> list = this.list();
        boolean first = true;
        for (PluginPath p : list) {
            if (first) {
                first = false;
            } else {
                builder.append("/");
            }
            builder.append(p.getType().getName());
            if (p.getName() == null) continue;
            builder.append("/").append(p.getName());
        }
        this.toString = builder.toString();
        return this.toString;
    }

    public String toString() {
        return this.path();
    }

    public int hashCode() {
        if (this.hash == 0) {
            List<PluginPath> list = this.list();
            int result = 1;
            for (PluginPath p : list) {
                result = 31 * result + (p == null ? 0 : Objects.hash(p.type, this.name));
            }
            this.hash = result;
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PluginPath)) {
            return false;
        }
        PluginPath p = (PluginPath)object;
        List<PluginPath> l1 = this.list();
        List<PluginPath> l2 = p.list();
        if (l1.size() == l2.size()) {
            for (int i = 0; i < l1.size(); ++i) {
                PluginPath p1 = l1.get(i);
                PluginPath p2 = l2.get(i);
                if (!(p1 != null && p2 != null ? !Objects.equals(p1.name, p2.name) || !Objects.equals(p1.type, p2.type) : p1 != p2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean startsWith(PluginPath<?> p) {
        List<PluginPath> l1 = this.list();
        List<PluginPath> l2 = p.list();
        if (l1.size() < l2.size()) {
            return false;
        }
        for (int i = 0; i < l2.size(); ++i) {
            PluginPath p1 = l1.get(i);
            PluginPath p2 = l2.get(i);
            if (!(p1 != null && p2 != null ? !(p2.type == null && p2.name != null && Objects.equals(p1.name, p2.name) || p2.type != null && p2.name == null && Objects.equals(p1.type, p2.type) || Objects.equals(p1.name, p2.name) && Objects.equals(p1.type, p2.type)) : p1 != p2)) continue;
            return false;
        }
        return true;
    }
}

