/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources.plugin;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.plugin.Plugin;
import net.e6tech.elements.common.resources.plugin.PluginFactory;
import net.e6tech.elements.common.resources.plugin.PluginPath;

public class PluginEntry<T> {
    private PluginPath<T> path;
    private Object plugin;
    private String description;

    public PluginEntry() {
    }

    public PluginEntry(PluginPath<T> path, Object plugin) {
        this.path = path;
        this.plugin = plugin;
        if (plugin instanceof Class) {
            Class cls = (Class)plugin;
            PluginEntry.validateClass((Class)plugin);
            this.deriveDescription(cls);
        } else if (plugin instanceof PluginFactory) {
            this.description = ((PluginFactory)plugin).description();
        } else if (plugin instanceof Plugin) {
            this.description = ((Plugin)plugin).description();
        } else {
            throw new IllegalArgumentException("Instance of type " + plugin.getClass() + " does not implement Plugin");
        }
    }

    public PluginEntry(PluginPath<T> path, Object plugin, String description) {
        this.path = path;
        this.plugin = plugin;
        this.description = description;
        if (plugin instanceof Class) {
            PluginEntry.validateClass((Class)plugin);
        }
    }

    public Object getPlugin() {
        return this.plugin;
    }

    public void setPlugin(Object plugin) {
        this.plugin = plugin;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PluginEntry<T> description(String description) {
        this.setDescription(description);
        return this;
    }

    public PluginPath<T> getPath() {
        return this.path;
    }

    protected void setPath(PluginPath<T> path) {
        this.path = path;
    }

    public static void validateClass(Class<?> type) {
        String CLASS = "Class ";
        if (!Plugin.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Class " + type + " does not implement Plugin.");
        }
        if (type.isInterface()) {
            throw new IllegalArgumentException("Class " + type + " is an interface; cannot be instantiated later.");
        }
        if (type.isMemberClass() && !Modifier.isStatic(type.getModifiers())) {
            throw new IllegalArgumentException("Class " + type + " is an non-static inner class; cannot be instantiated later.");
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new IllegalArgumentException("Class " + type + " is an abstract class; cannot be instantiated later.");
        }
        if (!Modifier.isPublic(type.getModifiers())) {
            throw new IllegalArgumentException("Class " + type + " is not public; cannot be instantiated later.");
        }
        try {
            type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Fail to instantiate class " + type + ": " + e.getMessage(), e);
        }
    }

    private void deriveDescription(Class<Plugin> type) {
        for (Class<Plugin> t = type; t != null && !t.equals(Object.class); t = t.getSuperclass()) {
            try {
                Field field = t.getField("pluginDescription");
                Object desc = field.get(null);
                if (desc == null) continue;
                this.description = desc.toString();
                break;
            }
            catch (IllegalAccessException | NoSuchFieldException e1) {
                Logger.suppress(e1);
            }
        }
        if (type != null && this.description == null) {
            try {
                Plugin p = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.description = p.description();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

