/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.concurrent;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.function.Function;

public class ObjectPool<T> {
    private ConcurrentLinkedDeque<Entry<T>> deque = new ConcurrentLinkedDeque();
    private ConcurrentLinkedDeque<Entry<T>> entries = new ConcurrentLinkedDeque();
    private ObjectFactory<T> factory;
    private Class<?> type;
    private int limit = 50;
    private int idleTimeout = 20000;
    private long lastCleanup = 0L;

    public ObjectPool<T> build() {
        if (this.type == null && this.factory == null) {
            Type superClass = this.getClass().getGenericSuperclass();
            if (superClass instanceof Class) {
                throw new IllegalArgumentException("Internal error: ObjectPool type information.  Try new ObjectPool<>().type(type).build(), new ObjectPool<>().factory(factory).build() or new ObjectPool<type>().build()");
            }
            if (superClass instanceof ParameterizedType) {
                Type[] types = ((ParameterizedType)superClass).getActualTypeArguments();
                if (types[0] instanceof Class) {
                    this.type = (Class)types[0];
                } else if (types[0] instanceof ParameterizedType && ((ParameterizedType)types[0]).getRawType() instanceof Class) {
                    this.type = (Class)((ParameterizedType)types[0]).getRawType();
                }
            }
        }
        return this;
    }

    public ObjectFactory<T> getFactory() {
        return this.factory;
    }

    public void setFactory(ObjectFactory<T> factory) {
        this.factory = factory;
    }

    public ObjectPool<T> factory(ObjectFactory<T> factory) {
        this.setFactory(factory);
        return this;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public ObjectPool<T> type(Class<?> type) {
        this.setType(type);
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public ObjectPool<T> limit(int limit) {
        this.setLimit(limit);
        return this;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public ObjectPool<T> idleTimeout(int idleTimeout) {
        this.setIdleTimeout(idleTimeout);
        return this;
    }

    public int size() {
        return this.deque.size();
    }

    public ObjectPool<T> clear() {
        this.deque.clear();
        this.entries.clear();
        return this;
    }

    public T create() {
        if (this.factory != null) {
            return this.factory.create();
        }
        if (this.type != null) {
            try {
                return (T)this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException("Internal error: ObjectPool constructed without actual type information");
    }

    public void accept(Consumer<T> consumer) {
        T t = null;
        try {
            t = this.checkOut();
            consumer.accept(t);
        }
        finally {
            if (t != null) {
                this.checkIn(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R apply(Function<T, R> function) {
        T t = null;
        try {
            t = this.checkOut();
            R r = function.apply(t);
            return r;
        }
        finally {
            if (t != null) {
                this.checkIn(t);
            }
        }
    }

    public T checkOut() {
        if (this.deque.isEmpty()) {
            this.lastCleanup = System.currentTimeMillis();
            return this.create();
        }
        try {
            Entry<T> entry = this.deque.removeLast();
            Object value = entry.value;
            entry.value = null;
            if (this.entries.size() < this.limit) {
                this.entries.offer(entry);
            }
            return value;
        }
        catch (NoSuchElementException e) {
            return this.create();
        }
    }

    public void checkIn(T t) {
        if (t == null) {
            return;
        }
        if (this.deque.size() < this.limit) {
            Entry<T> entry;
            try {
                entry = this.entries.remove();
            }
            catch (NoSuchElementException e) {
                entry = new Entry();
            }
            entry.value = t;
            entry.lastAccess = System.currentTimeMillis();
            this.deque.offerLast(entry);
        }
        this.cleanup();
    }

    public void cleanup() {
        long time = System.currentTimeMillis();
        if (time - this.lastCleanup > (long)this.idleTimeout) {
            this.lastCleanup = time;
            Iterator<Entry<T>> each = this.deque.iterator();
            while (each.hasNext()) {
                Entry<T> entry = each.next();
                if (time - entry.lastAccess <= (long)this.idleTimeout) break;
                each.remove();
            }
        }
    }

    private static class Entry<T> {
        long lastAccess;
        T value;

        private Entry() {
        }
    }

    @FunctionalInterface
    public static interface ObjectFactory<T> {
        public T create();
    }
}

