/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor.typed.worker;

import akka.actor.typed.ActorRef;
import akka.actor.typed.Behavior;
import akka.actor.typed.PostStop;
import akka.actor.typed.javadsl.ActorContext;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import net.e6tech.elements.common.actor.typed.Guardian;
import net.e6tech.elements.common.actor.typed.Receptor;
import net.e6tech.elements.common.actor.typed.Typed;
import net.e6tech.elements.common.actor.typed.worker.WorkEvents;
import net.e6tech.elements.common.actor.typed.worker.Worker;
import net.e6tech.elements.common.actor.typed.worker.WorkerPoolConfig;
import net.e6tech.elements.common.reflection.Reflection;

public class WorkerPool
extends Receptor<WorkEvents, WorkerPool> {
    private boolean cleanupScheduled = false;
    private Set<ActorRef<WorkEvents>> workers = new LinkedHashSet<ActorRef<WorkEvents>>();
    private Set<ActorRef<WorkEvents>> idleWorkers = new LinkedHashSet<ActorRef<WorkEvents>>();
    private Set<ActorRef<WorkEvents>> busyWorkers = new LinkedHashSet<ActorRef<WorkEvents>>();
    private LinkedList<Task> waiting = new LinkedList();
    protected WorkerPoolConfig config = new WorkerPoolConfig();
    private boolean stopped = true;

    public WorkerPool() {
    }

    public WorkerPool(WorkerPoolConfig config) {
        Reflection.copyInstance(this.config, config);
    }

    public synchronized void join() {
        while (!this.busyWorkers.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void stopped() {
        while (!this.stopped) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public Behavior<WorkEvents> setup(ActorContext<WorkEvents> ctx, Guardian guardian) {
        super.setup(ctx, guardian);
        for (int i = 0; i < this.config.getInitialCapacity(); ++i) {
            this.newWorker();
        }
        this.stopped = false;
        return this.getBehavior();
    }

    @Typed
    public WorkEvents.StatusResponse status(WorkEvents.Status message) {
        WorkEvents.StatusResponse response = new WorkEvents.StatusResponse();
        response.setIdleCount(this.idleWorkers.size());
        response.setWorkerCount(this.workers.size());
        response.setBusyCount(this.busyWorkers.size());
        response.setWaitCount(this.waiting.size());
        return response;
    }

    @Typed
    public void execute(WorkEvents.RunnableTask event) {
        if (!this.idleWorkers.isEmpty()) {
            Iterator<ActorRef<WorkEvents>> iterator = this.idleWorkers.iterator();
            ActorRef<WorkEvents> worker = iterator.next();
            iterator.remove();
            this.busyWorkers.add(worker);
            worker.tell((Object)event);
        } else if (this.workers.size() < this.config.getMaxCapacity()) {
            this.waiting.add(new Task(event.getSender(), event));
            this.newWorker();
        } else {
            this.waiting.add(new Task(event.getSender(), event));
        }
    }

    @Typed
    public void execute(WorkEvents.CallableTask event) {
        if (!this.idleWorkers.isEmpty()) {
            Iterator<ActorRef<WorkEvents>> iterator = this.idleWorkers.iterator();
            ActorRef<WorkEvents> worker = iterator.next();
            iterator.remove();
            this.busyWorkers.add(worker);
            worker.tell((Object)event);
        } else if (this.workers.size() < this.config.getMaxCapacity()) {
            this.waiting.add(new Task(event.getSender(), event));
            this.newWorker();
        } else {
            this.waiting.add(new Task(event.getSender(), event));
        }
    }

    private void newWorker() {
        ActorRef worker = this.childActor(Worker.class).spawn(new Worker(this.getSelf()));
        this.workers.add(worker);
        this.idle(worker);
    }

    @Typed
    private void idle(WorkEvents.IdleWorker event) {
        this.idle(event.getWorker());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void idle(ActorRef<WorkEvents> worker) {
        if (!this.waiting.isEmpty()) {
            Task task = this.waiting.removeFirst();
            this.busyWorkers.add(worker);
            worker.tell((Object)task.getWork());
        } else {
            this.busyWorkers.remove(worker);
            this.idleWorkers.add(worker);
            if (this.busyWorkers.isEmpty()) {
                WorkerPool workerPool = this;
                synchronized (workerPool) {
                    this.notifyAll();
                }
            }
            this.scheduleCleanup(new WorkEvents.ScheduleCleanup());
        }
    }

    @Typed
    private void scheduleCleanup(WorkEvents.ScheduleCleanup message) {
        if (this.cleanupScheduled) {
            return;
        }
        if (this.config.getIdleTimeout() == 0L) {
            return;
        }
        if (this.idleWorkers.size() <= this.config.getInitialCapacity()) {
            return;
        }
        Duration interval = Duration.ofMillis(this.config.getIdleTimeout());
        this.getContext().scheduleOnce(interval, this.getSelf(), (Object)new WorkEvents.Cleanup());
        this.cleanupScheduled = true;
    }

    @Typed
    private void cleanup(WorkEvents.Cleanup message) {
        int count = this.idleWorkers.size() - this.config.getInitialCapacity();
        Iterator<ActorRef<WorkEvents>> iterator = this.idleWorkers.iterator();
        ArrayList<ActorRef> stopList = new ArrayList<ActorRef>(count);
        for (int i = 0; i < count; ++i) {
            ActorRef worker = iterator.next();
            iterator.remove();
            stopList.add(worker);
        }
        for (ActorRef worker : stopList) {
            this.workers.remove(worker);
            this.idleWorkers.remove(worker);
            this.getContext().stop(worker);
        }
        this.cleanupScheduled = false;
    }

    @Typed
    synchronized void stopped(PostStop message) {
        this.stopped = true;
        this.notifyAll();
    }

    private class Task {
        ActorRef sender;
        WorkEvents work;

        public Task(ActorRef sender, WorkEvents work) {
            this.sender = sender;
            this.work = work;
        }

        public ActorRef getSender() {
            return this.sender;
        }

        public WorkEvents getWork() {
            return this.work;
        }
    }
}

