/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources.plugin;

import java.util.LinkedHashMap;
import java.util.Map;
import net.e6tech.elements.common.resources.plugin.Plugin;
import net.e6tech.elements.common.resources.plugin.PluginFactory;
import net.e6tech.elements.common.resources.plugin.PluginManager;
import net.e6tech.elements.common.resources.plugin.PluginPath;
import net.e6tech.elements.common.util.SystemException;

public class PluginMap<K, V extends Plugin>
implements PluginFactory {
    private Map<K, Object> map = new LinkedHashMap<K, Object>();
    private PluginPath<V> pluginPath;
    private PluginManager pluginManager;

    public PluginMap<K, V> create(PluginManager pluginManager) {
        PluginMap copy;
        try {
            copy = (PluginMap)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        copy.pluginManager = pluginManager;
        copy.map = this.map;
        return copy;
    }

    @Override
    public void initialize(PluginPath path) {
        this.pluginPath = path;
    }

    public void put(K key, Object object) {
        this.map.put(key, object);
    }

    public void put(K key, V singleton) {
        this.map.put(key, singleton);
    }

    public void put(K key, Class<? extends V> cls) {
        this.map.put(key, cls);
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public V get(K key) {
        Object obj = this.map.get(key);
        return this.pluginManager.createInstance(this.pluginPath, obj, new Object[0]);
    }

    public Object remove(K key) {
        return this.map.remove(key);
    }

    public Map<K, Object> plugins() {
        return this.map;
    }

    public Map<K, V> map() {
        return this.pluginManager.getResources().configurator().computeIfAbsent(this.pluginPath.path(), key -> {
            LinkedHashMap<K, V> m = new LinkedHashMap<K, V>();
            for (Map.Entry<K, Object> entry : this.map.entrySet()) {
                Object obj = entry.getValue();
                V value = this.pluginManager.createInstance(this.pluginPath, obj, new Object[0]);
                m.put(entry.getKey(), value);
            }
            return m;
        });
    }
}

