/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.reflection;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class Lambda {
    private static final Cache<Method, Function> GETTERS = CacheBuilder.newBuilder().weakValues().build();
    private static final Cache<Method, BiConsumer> SETTERS = CacheBuilder.newBuilder().weakValues().build();

    private static Function createGetter(MethodHandles.Lookup lookup, MethodHandle getter) throws Exception {
        CallSite site = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), getter, getter.type());
        try {
            return site.getTarget().invokeExact();
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }

    private static BiConsumer createSetter(MethodHandles.Lookup lookup, MethodHandle setter) throws Exception {
        CallSite site = LambdaMetafactory.metafactory(lookup, "accept", MethodType.methodType(BiConsumer.class), MethodType.methodType(Void.TYPE, Object.class, Object.class), setter, setter.type());
        try {
            return site.getTarget().invokeExact();
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }

    public static Function reflectGetter(MethodHandles.Lookup lookup, Method getter) throws ReflectiveOperationException {
        try {
            return (Function)GETTERS.get((Object)getter, () -> Lambda.createGetter(lookup, lookup.unreflect(getter)));
        }
        catch (ExecutionException e) {
            throw new ReflectiveOperationException(e.getCause());
        }
    }

    public static BiConsumer reflectSetter(MethodHandles.Lookup lookup, Method setter) throws ReflectiveOperationException {
        try {
            return (BiConsumer)SETTERS.get((Object)setter, () -> Lambda.createSetter(lookup, lookup.unreflect(setter)));
        }
        catch (ExecutionException e) {
            throw new ReflectiveOperationException(e.getCause());
        }
    }

    private Lambda() {
    }
}

